/*
 * Decompiled with CFR 0.152.
 */
package webplugin;

import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import webplugin.Environment;

class AAction {
    Element o_xml;
    Environment o_env;

    public AAction(Element p_elem, Environment p_env) {
        this.o_xml = p_elem;
        this.o_env = p_env;
    }

    public boolean isValid() {
        if (this.o_xml == null) {
            return true;
        }
        Condition x_cond = this.makeCondition(this.o_xml.getChild("conditions"));
        if (x_cond != null) {
            return x_cond.check();
        }
        return true;
    }

    public int getTime() {
        if (this.o_xml == null) {
            return 0;
        }
        Element x_time = this.o_xml.getChild("time");
        if (x_time != null) {
            return Integer.parseInt(x_time.getText());
        }
        return 0;
    }

    public void execute() {
        if (this.o_xml == null) {
            return;
        }
        List x_data = this.o_xml.getChildren("data");
        for (Element x_item : x_data) {
            Attribute x_key = x_item.getAttribute("key");
            Attribute x_value = x_item.getAttribute("value");
            if (x_key == null) {
                System.err.println("No key value for data.");
                return;
            }
            if (x_value == null) {
                System.err.println("No value for data.");
                return;
            }
            this.o_env.put(x_key.getValue(), x_value.getValue());
        }
    }

    Condition makeCondition(Element p_xml) {
        if (p_xml == null) {
            return null;
        }
        if (p_xml.getName().equals("conditions")) {
            return this.makeCondition((Element)p_xml.getChildren().get(0));
        }
        if (p_xml.getName().equals("and")) {
            return new And(p_xml);
        }
        if (p_xml.getName().equals("or")) {
            return new Or(p_xml);
        }
        if (p_xml.getName().equals("equal")) {
            return new Equal(p_xml);
        }
        if (p_xml.getName().equals("notequal")) {
            return new NotEqual(p_xml);
        }
        System.err.println("error - unknown condition type: " + p_xml.getName());
        return null;
    }

    abstract class Condition {
        protected Element o_root;

        Condition(Element p_xml) {
            this.o_root = p_xml;
        }

        abstract boolean check();
    }

    class Equal
    extends Condition {
        Equal(Element p_xml) {
            super(p_xml);
        }

        boolean check() {
            Attribute x_key = this.o_root.getAttribute("key");
            if (x_key == null) {
                System.err.println("No key specified in equal condition.");
                return true;
            }
            Attribute x_value = this.o_root.getAttribute("value");
            if (x_value == null) {
                System.err.println("No value specified in equal condition.");
                return true;
            }
            String x_lhs = AAction.this.o_env.get(x_key.getValue());
            String x_rhs = x_value.getValue();
            if (x_lhs == null) {
                return false;
            }
            return x_lhs.equals(x_rhs);
        }
    }

    class NotEqual
    extends Condition {
        NotEqual(Element p_xml) {
            super(p_xml);
        }

        boolean check() {
            Attribute x_key = this.o_root.getAttribute("key");
            if (x_key == null) {
                System.err.println("No key specified in not-equal condition.");
                return true;
            }
            Attribute x_value = this.o_root.getAttribute("value");
            if (x_value == null) {
                System.err.println("No value specified in not-equal condition.");
                return true;
            }
            String x_lhs = AAction.this.o_env.get(x_key.getValue());
            String x_rhs = x_value.getValue();
            if (x_lhs == null) {
                return true;
            }
            return !x_lhs.equals(x_rhs);
        }
    }

    class And
    extends Condition {
        And(Element p_xml) {
            super(p_xml);
        }

        boolean check() {
            boolean x_result = true;
            Iterator i = this.o_root.getChildren().iterator();
            while (i.hasNext()) {
                Condition x_cond = AAction.this.makeCondition((Element)i.next());
                if (x_cond == null) continue;
                x_result &= x_cond.check();
            }
            return x_result;
        }
    }

    class Or
    extends Condition {
        Or(Element p_xml) {
            super(p_xml);
        }

        boolean check() {
            boolean x_result = true;
            Iterator i = this.o_root.getChildren().iterator();
            while (i.hasNext()) {
                Condition x_cond = AAction.this.makeCondition((Element)i.next());
                if (x_cond == null) continue;
                x_result &= x_cond.check();
            }
            return x_result;
        }
    }
}

