/*
 * Decompiled with CFR 0.152.
 */
package webplugin;

import ic.doc.extension.IAnimator;
import ic.doc.extension.LTSA;
import ic.doc.extension.LTSAButton;
import ic.doc.extension.LTSAPlugin;
import ic.doc.ltsa.common.infra.EventClient;
import ic.doc.ltsa.common.infra.LTSEvent;
import ic.doc.ltsa.frontend.editor.ColoredEditorKit;
import ic.doc.ltsa.lts.ltl.PredicateDefinition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.EditorKit;
import webplugin.Action;
import webplugin.Fluent;
import webplugin.FluentContainer;
import webplugin.FluentSpec;
import webplugin.Role;
import webplugin.ShowBlock;

public class NewWebPlugin
extends LTSAPlugin
implements EventClient {
    private static final int s_port = 1235;
    private List o_toolbar_buttons;
    private ServerThread o_server;
    private Boolean o_running;
    private JEditorPane o_editor;
    private JScrollPane o_scroll;
    private ServerSocket o_server_socket;
    private FluentContainer o_fluent_cont;
    private Font o_fixed_font;
    private Font o_big_font;
    private boolean o_error = false;
    private String o_last_action = "";

    public NewWebPlugin() {
    }

    public NewWebPlugin(LTSA p_ltsa) {
        super(p_ltsa);
    }

    public void initialise() {
        this.o_running = new Boolean(false);
        this.o_toolbar_buttons = new ArrayList();
        this.o_fluent_cont = FluentContainer.getInstance();
        this.initEditor();
        this.createButtons();
    }

    private void initEditor() {
        this.o_fixed_font = new Font("Monospaced", 0, 12);
        this.o_big_font = new Font("Monospaced", 0, 20);
        this.o_editor = new JEditorPane();
        this.o_editor.setEditorKit((EditorKit)new ColoredEditorKit());
        this.o_editor.setFont(this.o_fixed_font);
        this.o_editor.setBackground(Color.white);
        this.o_editor.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.o_scroll = new JScrollPane(this.o_editor, 22, 30);
    }

    public String getName() {
        return "Web Animator";
    }

    public boolean addAsTab() {
        return true;
    }

    public Component getComponent() {
        return this.o_scroll;
    }

    public boolean addToolbarButtons() {
        return true;
    }

    public List getToolbarButtons() {
        return this.o_toolbar_buttons;
    }

    public boolean addMenusToMenuBar() {
        return false;
    }

    public boolean useOwnMenuBar() {
        return false;
    }

    private void createButtons() {
        ImageIcon x_icon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/icon/web.gif"));
        LTSAButton x_button = new LTSAButton(x_icon, "Start animator", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewWebPlugin.this.toggle_animator();
            }
        });
        this.o_toolbar_buttons.add(x_button);
    }

    public boolean providesNewFile() {
        return true;
    }

    public void newFile() {
        this.o_editor.setText("");
    }

    public boolean providesOpenFile() {
        return true;
    }

    public void openFile(File p_file) {
        try {
            BufferedReader x_in = new BufferedReader(new FileReader(p_file));
            StringBuffer x_contents = new StringBuffer();
            String x_line = "";
            while ((x_line = x_in.readLine()) != null) {
                x_contents.append(String.valueOf(x_line) + "\n");
            }
            this.o_editor.setText(x_contents.toString());
        }
        catch (FileNotFoundException p_fnfe) {
            this.getLTSA().outln("File not found.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getFileExtension() {
        return "xml";
    }

    public boolean providesSaveFile() {
        return true;
    }

    public void saveFile(FileOutputStream p_fos) {
        PrintWriter x_pw = new PrintWriter(p_fos);
        x_pw.println(this.o_editor.getText());
        x_pw.close();
    }

    public void setBigFont(boolean p_big) {
        if (p_big) {
            this.o_editor.setFont(this.o_big_font);
        } else {
            this.o_editor.setFont(this.o_fixed_font);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toggle_animator() {
        Boolean bl = this.o_running;
        synchronized (bl) {
            if (!this.o_running.booleanValue()) {
                LTSA x_ltsa = this.getLTSA();
                IAnimator x_anim = x_ltsa.getAnimator();
                System.out.println("*** Starting webserver ***");
                try {
                    this.o_server_socket = new ServerSocket(1235);
                }
                catch (IOException p_ioe) {
                    System.err.println("Failed to create new server socket." + p_ioe);
                }
                this.o_server = new ServerThread(x_anim, this.o_server_socket);
                this.o_server.start();
            } else {
                System.out.println("*** Stopping webserver ***");
                try {
                    this.o_server_socket.close();
                }
                catch (IOException p_ioe) {
                    System.err.println("Failed to close socket." + p_ioe);
                }
            }
            this.o_running = new Boolean(this.o_running == false);
        }
    }

    public void ltsAction(LTSEvent p_event) {
        if (p_event.name != null) {
            this.o_fluent_cont.update(p_event.name);
        }
    }

    static String lastPart(String p_str) {
        if (p_str.indexOf(46) < 0) {
            return p_str;
        }
        return p_str.substring(p_str.lastIndexOf(46) + 1, p_str.length());
    }

    class ServerThread
    extends Thread {
        private ServerSocket o_ss;
        private IAnimator o_anim;
        private BitSet o_actions;
        private Map o_actions_performed;
        private ArrayList o_request_handlers = new ArrayList();
        private FluentSpec o_fspec;

        public ServerThread(IAnimator p_anim, ServerSocket p_socket) {
            this.o_anim = p_anim;
            this.o_ss = p_socket;
            this.o_actions_performed = new HashMap();
            this.o_fspec = new FluentSpec(NewWebPlugin.this.o_editor.getText());
            NewWebPlugin.this.o_fluent_cont.removeAllFluents();
            NewWebPlugin.this.o_fluent_cont.removeAllActions();
            NewWebPlugin.this.o_fluent_cont.removeAllRoles();
            NewWebPlugin.this.o_fluent_cont.clearSession();
            for (Role x_role : this.o_fspec.getRoles()) {
                NewWebPlugin.this.o_fluent_cont.add(x_role);
            }
            for (Action x_act : this.o_fspec.getActions()) {
                NewWebPlugin.this.o_fluent_cont.add(x_act);
            }
            Set x_fluents = NewWebPlugin.this.getLTSA().getAllFluentDefinitions();
            Iterator i = x_fluents.iterator();
            while (i.hasNext()) {
                NewWebPlugin.this.o_fluent_cont.add(new Fluent((PredicateDefinition)i.next()));
            }
        }

        public synchronized BitSet getCurrentState() {
            return this.o_actions;
        }

        public synchronized void setState(BitSet p_state) {
            this.o_actions = p_state;
        }

        public void run() {
            this.o_actions = this.o_anim.initialise(null);
            try {
                while (NewWebPlugin.this.o_running.booleanValue()) {
                    Socket x_client = this.o_ss.accept();
                    RequestHandler x_rh = new RequestHandler(x_client, this.o_anim, this.o_fspec, this, this.o_actions_performed);
                    x_rh.start();
                    for (Thread x_thread : this.o_request_handlers) {
                        x_thread.interrupt();
                    }
                    this.o_request_handlers.add(x_rh);
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }

    class RequestHandler
    extends Thread {
        private ServerThread o_server;
        private Socket o_client;
        private IAnimator o_anim;
        private FluentSpec o_fspec;
        private BitSet o_actions;
        private String o_role;
        private Map o_actions_performed;
        private boolean o_state_changed = false;
        private boolean o_error_act = false;

        RequestHandler(Socket p_client, IAnimator p_anim, FluentSpec p_fspec, ServerThread p_server, Map p_performed) {
            this.o_client = p_client;
            this.o_anim = p_anim;
            this.o_fspec = p_fspec;
            this.o_server = p_server;
            this.o_actions_performed = new HashMap();
        }

        public void run() {
            try {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(this.o_client.getInputStream()));
                while ((line = in.readLine()) != null) {
                    if (line.length() != 0) {
                        if (!line.startsWith("GET")) continue;
                        if (line.indexOf("?") > -1) {
                            this.processrequest(line);
                            this.writeOutXML();
                            return;
                        }
                        String x_fn = line.substring(line.indexOf("/"), line.indexOf(" HTTP")).trim();
                        if (x_fn.trim().endsWith("favicon.ico")) {
                            return;
                        }
                        if (!(x_fn = x_fn.replace("%20", " ")).trim().equals("") && !x_fn.trim().equals("/")) {
                            this.serveFile(x_fn.substring(1));
                            return;
                        }
                        this.writeOutXML();
                        return;
                    }
                    break;
                }
            }
            catch (IOException p_ioe) {
                System.err.println(p_ioe);
            }
        }

        private boolean userActionPossible() {
            String[] x_alphabet = this.o_anim.getMenuNames();
            boolean x_possible_user_action = false;
            int i = 1;
            while (i < x_alphabet.length) {
                Action x_act = NewWebPlugin.this.o_fluent_cont.getAction(x_alphabet[i]);
                x_possible_user_action |= NewWebPlugin.this.o_fluent_cont.getAllControlledActions().contains(x_alphabet[i]) && this.o_server.getCurrentState().get(i);
                ++i;
            }
            return x_possible_user_action;
        }

        private boolean systemActionPossible() {
            String[] x_alphabet = this.o_anim.getMenuNames();
            boolean x_possible_system_action = false;
            int i = 1;
            while (i < x_alphabet.length) {
                for (Role x_role : NewWebPlugin.this.o_fluent_cont.getRoles()) {
                    x_possible_system_action |= !x_role.getControlledActions().contains(x_alphabet[i]) && this.o_server.getCurrentState().get(i);
                }
                ++i;
            }
            return x_possible_system_action;
        }

        private boolean actionPossibleForRole(String p_role) {
            String[] x_alphabet = this.o_anim.getMenuNames();
            boolean x_action_available = false;
            int i = 1;
            while (i < x_alphabet.length) {
                x_action_available |= this.isPossibleActionForRole(x_alphabet[i], p_role) && this.o_server.getCurrentState().get(i);
                ++i;
            }
            return x_action_available;
        }

        private boolean isPossibleActionForRole(String p_action, String p_role) {
            List x_role_actions = NewWebPlugin.this.o_fluent_cont.getRole(p_role).getControlledActions();
            return x_role_actions.contains(p_action);
        }

        private void serveFile(String p_req) {
            FileInputStream x_is = null;
            PrintStream x_ps = null;
            try {
                try {
                    int n;
                    File x_file = new File(String.valueOf(NewWebPlugin.this.getLTSA().getCurrentDirectory()) + System.getProperty("file.separator") + p_req);
                    byte[] x_buf = new byte[10000];
                    x_is = new FileInputStream(x_file);
                    x_ps = new PrintStream(this.o_client.getOutputStream());
                    if (!x_file.exists()) {
                        this.notFound(p_req);
                        try {
                            x_is.close();
                            x_ps.flush();
                            x_ps.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                    String x_ext = p_req.substring(p_req.lastIndexOf("."));
                    String x_contenttype = x_ext.equals("jpg") ? "image/jpeg" : (x_ext.equals("jpeg") ? "image/jpeg" : (x_ext.equals("gif") ? "image/gif" : (x_ext.equals("png") ? "image/png" : (x_ext.equals("html") ? "text/html" : "unknown/unknown"))));
                    x_ps.print("HTTP/1.0 200\nContent-Type: " + x_contenttype + "\n\n");
                    while ((n = x_is.read(x_buf)) > 0) {
                        x_ps.write(x_buf, 0, n);
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
            finally {
                try {
                    x_is.close();
                    x_ps.flush();
                    x_ps.close();
                }
                catch (Exception exception) {}
            }
        }

        private Set getEnabledActions() {
            HashSet<String> x_ret = new HashSet<String>();
            String[] x_alphabet = this.o_anim.getMenuNames();
            int i = 1;
            while (i < x_alphabet.length) {
                if (this.o_server.getCurrentState().get(i)) {
                    x_ret.add(x_alphabet[i]);
                }
                ++i;
            }
            return x_ret;
        }

        private String output() {
            Role x_role = NewWebPlugin.this.o_fluent_cont.getRole(this.o_role);
            StringBuffer x_buf = new StringBuffer(1000);
            Set x_enabled = this.getEnabledActions();
            if (x_role.getHeader() != null) {
                x_buf.append(x_role.getHeader().getDisplay());
            }
            for (ShowBlock x_sb : x_role.getShowBlocks()) {
                System.out.println("checking : " + x_sb.getExpression().check());
                x_sb.setRole(this.o_role);
                if (!x_sb.getExpression().check()) continue;
                x_buf = x_buf.append(x_sb.getDisplay(x_enabled));
            }
            x_buf = x_buf.append(this.remainingEnabled(x_enabled, x_role));
            if (x_role.getFooter() != null) {
                x_buf.append(x_role.getFooter().getDisplay());
            }
            return x_buf.toString();
        }

        private void notFound(String p_req) {
            System.out.println("404 - file " + p_req + " not found.");
        }

        private void writeOutXML() {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(this.o_client.getInputStream()));
                PrintWriter out = new PrintWriter(new OutputStreamWriter(this.o_client.getOutputStream()));
                ByteArrayOutputStream x_baos = new ByteArrayOutputStream();
                PrintWriter x_xml_stream = new PrintWriter(new OutputStreamWriter(x_baos));
                String[] x_alphabet = this.o_anim.getMenuNames();
                x_xml_stream.println("<html>");
                x_xml_stream.println("<form action=\"/\" method=\"GET\">");
                x_xml_stream.println("<input type=\"hidden\" name=\"role\" value=\"" + this.o_role + "\" />");
                x_xml_stream.println(this.output());
                x_xml_stream.println("</form>");
                if (NewWebPlugin.this.o_error) {
                    x_xml_stream.println("<br /><br /><hr /><p><center><h1>ERROR!</h1><h3>That action ( " + NewWebPlugin.this.o_last_action + " ) was is not enabled in the current state</h3></center></p>");
                }
                x_xml_stream.println("</html>");
                x_xml_stream.flush();
                if (this.o_state_changed || this.o_error_act) {
                    out.print("HTTP/1.1 302 Found\n");
                    out.print("Location: " + FluentContainer.getInstance().getBaseURL(this.o_role) + "\n");
                    out.print("Content-Type: text/plain\n\n");
                    this.o_error_act = false;
                    this.o_state_changed = false;
                } else {
                    out.print("HTTP/1.0 200\r\n");
                    out.print("Content-Type: text/html\r\n");
                    out.print("Content-Length: " + x_baos.toString().length() + "\r\n");
                    out.print("\r\n");
                    out.print(x_baos.toString());
                }
                out.close();
                in.close();
                this.o_client.close();
            }
            catch (IOException p_ioe) {
                System.err.println(p_ioe);
            }
        }

        private String remainingEnabled(Set p_acts, Role p_role) {
            String x_buf = "<p>\n";
            for (String x_act : p_acts) {
                if (!this.isPossibleActionForRole(x_act, p_role.getName())) continue;
                x_buf = String.valueOf(x_buf) + "<input type=\"submit\" name=\"" + x_act + "\" value=\"" + NewWebPlugin.lastPart(x_act) + "\" />\n";
            }
            x_buf = String.valueOf(x_buf) + "</p>\n";
            return x_buf;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private synchronized void processrequest(String p_line) {
            int step = -1;
            String afterq = p_line.substring(p_line.indexOf("?") + 1);
            afterq = afterq.substring(0, afterq.indexOf(" "));
            StringTokenizer x_st = new StringTokenizer(afterq.trim(), "&");
            while (x_st.hasMoreTokens()) {
                String[] x_pair = x_st.nextToken().split("=");
                if (x_pair.length <= 1) continue;
                try {
                    x_pair[0] = URLDecoder.decode(x_pair[0], "UTF-8");
                    x_pair[1] = URLDecoder.decode(x_pair[1], "UTF-8");
                }
                catch (UnsupportedEncodingException p_uee) {
                    p_uee.printStackTrace();
                }
                if (x_pair[0].equals("role")) {
                    this.o_role = x_pair[1];
                }
                if (x_pair[0].endsWith(".x")) {
                    x_pair[0] = x_pair[0].substring(0, x_pair[0].lastIndexOf(".x"));
                } else if (x_pair[0].endsWith(".y")) {
                    x_pair[0] = x_pair[0].substring(0, x_pair[0].lastIndexOf(".y"));
                }
                char[] ca = x_pair[0].toCharArray();
                boolean letters = true;
                int i = 0;
                while (i < ca.length) {
                    letters &= Character.isLetter(ca[i]);
                    ++i;
                }
                System.out.println("role : " + this.o_role);
                if (NewWebPlugin.this.o_fluent_cont.getRole(this.o_role).getControlledActions().contains(x_pair[0])) {
                    step = this.getNumberForAction(x_pair[0]);
                    continue;
                }
                System.out.println("adding data " + x_pair[0] + " = " + x_pair[1]);
                NewWebPlugin.this.o_fluent_cont.getSession().put(x_pair[0], x_pair[1]);
            }
            String[] x_alphabet = this.o_anim.getMenuNames();
            if (!this.o_anim.isError() && step > -1) {
                HashSet<String> x_acts;
                NewWebPlugin.this.o_last_action = NewWebPlugin.lastPart(x_alphabet[step]);
                if (!this.o_server.getCurrentState().get(step)) {
                    System.out.println("***************************************");
                    System.out.println("**              ERROR                **");
                    System.out.println("***************************************");
                    this.o_error_act = true;
                    NewWebPlugin.this.o_error = true;
                    return;
                }
                this.o_server.setState(this.o_anim.menuStep(step));
                this.o_state_changed = true;
                NewWebPlugin.this.o_error = false;
                System.out.println("Making transition " + x_alphabet[step]);
                Action x_act = NewWebPlugin.this.o_fluent_cont.getAction(x_alphabet[step]);
                if (x_act != null) {
                    x_act.execute();
                }
                if ((x_acts = (HashSet<String>)this.o_actions_performed.get(this.o_role)) == null) {
                    x_acts = new HashSet<String>();
                }
                x_acts.add(x_alphabet[step]);
                this.o_actions_performed.put(this.o_role, x_acts);
                while (this.systemActionPossible()) {
                    int actno;
                    ArrayList<Integer> x_possible = new ArrayList<Integer>();
                    int i = 1;
                    while (i < x_alphabet.length) {
                        Action x_act2 = NewWebPlugin.this.o_fluent_cont.getAction(x_alphabet[i]);
                        System.out.println("action found for " + x_alphabet[i] + "?" + (x_act2 != null));
                        if ((x_act2 == null || x_act2.isValid()) && this.o_server.getCurrentState().get(i) && !NewWebPlugin.this.o_fluent_cont.getAllControlledActions().contains(x_alphabet[i])) {
                            x_possible.add(new Integer(i));
                        }
                        ++i;
                    }
                    if (x_possible.size() > 1) {
                        int x_random = (int)Math.round(Math.random() * (double)x_possible.size());
                        if (x_random < 0) {
                            x_random = 0;
                        }
                        if (x_random >= x_possible.size()) {
                            x_random = x_possible.size() - 1;
                        }
                        actno = (Integer)x_possible.get(x_random);
                    } else {
                        if (x_possible.size() == 0) break;
                        actno = (Integer)x_possible.get(0);
                    }
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException x_random) {
                        // empty catch block
                    }
                    this.o_server.setState(this.o_anim.menuStep(actno));
                    HashSet<String> x_acts2 = (HashSet<String>)this.o_actions_performed.get(this.o_role);
                    if (x_acts2 == null) {
                        x_acts2 = new HashSet<String>();
                    }
                    x_acts2.add(x_alphabet[actno]);
                    this.o_actions_performed.put(this.o_role, x_acts2);
                    Action x_act3 = NewWebPlugin.this.o_fluent_cont.getAction(x_alphabet[actno]);
                    if (x_act3 == null) continue;
                    x_act3.execute();
                }
            }
            try {
                this.wait(500L);
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private int getNumberForAction(String p_act) {
            String[] x_alphabet = this.o_anim.getMenuNames();
            int i = 0;
            while (i < x_alphabet.length) {
                if (x_alphabet[i].equals(p_act)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }
}

