/*
 * Decompiled with CFR 0.152.
 */
package webplugin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import webplugin.Expression;
import webplugin.FluentContainer;
import webplugin.NewWebPlugin;

class ShowBlock {
    private Element o_elem;
    private Map o_session;
    private Set o_enabled = null;
    private String o_role;

    ShowBlock(Element p_elem, Map p_session) {
        this.o_elem = p_elem;
        this.o_session = p_session;
    }

    Expression getExpression() {
        return Expression.makeExpression(this.o_elem.getChild("expression"));
    }

    protected String getDisplay() {
        return this.getDisplay(null);
    }

    protected String getDisplay(Set p_enabled) {
        ByteArrayOutputStream x_baos = new ByteArrayOutputStream(1000);
        try {
            Element x_elem = this.rewrite((Element)this.o_elem.clone(), p_enabled);
            new XMLOutputter().output(x_elem.getChild("display").getContent(), (OutputStream)x_baos);
        }
        catch (IOException p_ioe) {
            System.err.println(p_ioe);
        }
        System.out.println("returning : " + x_baos.toString());
        return x_baos.toString();
    }

    private Element rewrite(Element p_elem) {
        return this.rewrite(p_elem, this.o_enabled);
    }

    private Element rewrite(Element p_elem, Set p_enabled) {
        this.o_enabled = p_enabled;
        Element x_new = new Element(p_elem.getName());
        List x_attrs = p_elem.getAttributes();
        for (Attribute x_attr : x_attrs) {
            x_new.setAttribute(x_attr.getName(), x_attr.getValue());
        }
        for (Object x_next : p_elem.getContent()) {
            Element x_input;
            if (x_next instanceof Text) {
                x_new.addContent((Text)((Text)x_next).clone());
                continue;
            }
            if (x_next instanceof Comment) {
                x_new.addContent((Comment)((Comment)x_next).clone());
                continue;
            }
            Element x_elem = (Element)x_next;
            if (x_elem.getName().equals("button")) {
                x_input = new Element("input");
                x_input.setAttribute("type", "submit");
                x_input.setAttribute("name", x_elem.getText());
                x_input.setAttribute("value", NewWebPlugin.lastPart(x_elem.getText()));
                p_enabled.remove(x_elem.getText());
                x_new.addContent(x_input);
                continue;
            }
            if (x_elem.getName().equals("imagebutton")) {
                x_input = new Element("input");
                x_input.setAttribute("type", "image");
                x_input.setAttribute("name", x_elem.getText());
                x_input.setAttribute("value", x_elem.getText());
                x_input.setAttribute("src", x_elem.getAttribute("src").getValue());
                x_input.setAttribute("alt", x_elem.getAttribute("alt").getValue());
                p_enabled.remove(x_elem.getText());
                x_new.addContent(x_input);
                continue;
            }
            if (x_elem.getName().equals("value")) {
                x_new.addContent(this.getValue(x_elem.getAttribute("name").getValue()));
                continue;
            }
            if (x_elem.getName().equals("link")) {
                Element x_anchor = new Element("a");
                String x_action = x_elem.getChildText("action");
                String x_act = "&" + x_action + "=" + x_action;
                p_enabled.remove(x_action);
                String x_datastring = "";
                List x_data = x_elem.getChildren("data");
                for (Element x_datum : x_data) {
                    String x_key = x_datum.getAttribute("key").getValue();
                    String x_val = x_datum.getAttribute("value").getValue();
                    x_datastring = String.valueOf(x_datastring) + "&" + x_key + "=" + x_val;
                }
                x_anchor.setAttribute("href", String.valueOf(this.getBaseURL()) + x_act + x_datastring);
                Element x_content = x_elem.getChild("content");
                x_anchor.addContent(this.rewrite(x_content));
                x_new.addContent(x_anchor);
                continue;
            }
            if (x_elem.getName().equals("include")) {
                String x_filename = x_elem.getAttribute("name").getValue();
                Element x_contents = null;
                if (FluentContainer.getInstance().checkCache(x_filename) == null) {
                    x_contents = this.readFile(new File(x_filename));
                    FluentContainer.getInstance().updateCache(x_filename, x_contents);
                }
                x_new.addContent(this.rewrite(x_contents));
                continue;
            }
            if (x_elem.getName().equals("img")) {
                if (x_elem.hasChildren()) {
                    String x_src_string = "";
                    for (Element x_el : x_elem.getChildren()) {
                        x_src_string = String.valueOf(x_src_string) + this.rewrite(x_el).getTextTrim();
                    }
                    Element x_img = new Element("img");
                    x_img.setAttribute("src", x_src_string);
                    x_new.addContent(x_img);
                    continue;
                }
                x_new.addContent(this.rewrite(x_elem));
                continue;
            }
            x_new.addContent(this.rewrite(x_elem));
        }
        return x_new;
    }

    private Element readFile(File p_file) {
        SAXBuilder x_in = new SAXBuilder();
        try {
            Document x_doc = x_in.build((InputStream)new FileInputStream(p_file));
            return x_doc.getRootElement();
        }
        catch (Exception e) {
            System.err.println(e);
            return null;
        }
    }

    private String getNumberForAction(String p_action) {
        return "4";
    }

    private String getValue(String p_key) {
        return (String)FluentContainer.getInstance().getSession().get(p_key);
    }

    private String getBaseURL() {
        return FluentContainer.getInstance().getBaseURL(this.o_role);
    }

    void setRole(String p_role) {
        this.o_role = p_role;
    }
}

