/*									Generic Base M

/* Benny Lo
 *
 *
 */
  
/* Generic.Base.c 
   - captures all the packets that it can hear and report it back to the UART
   - forward all incoming UART messages out to the radio
*/
includes AM;
includes UbiMonMsg;
includes SensorType;

module GenericBaseM {
	provides interface StdControl;
	uses {
		interface StdControl as UARTControl;
		interface BareSendMsg as UARTSend;
		interface ReceiveMsg as UARTReceive;

		interface StdControl as RadioControl;
		interface SendMsg as DataMsg;
		interface ReceiveMsg as ResetCounterMsg;
#ifdef REMOVE_COMM_OVERHEAD
		interface CC1000Control;
#endif
		interface Leds;
	}
}

implementation
{

	TOS_Msg buffer; 
	TOS_MsgPtr ourBuffer;
	bool sendPending;	
	TOS_Msg sendingmsg;
	
  /* Generic.Base.Init:  
     initialize lower components.
     initialize component state, including constant portion of msgs.
  */

	command result_t StdControl.init() 
	{
		result_t ok1, ok2, ok3;

		ourBuffer = &buffer;		
		
		ok1 = call UARTControl.init();
		ok2 = call RadioControl.init();
		ok3 = call Leds.init();
		
	
		sendPending = FALSE;
		
		return rcombine3(ok1, ok2, ok3);
	}

	command result_t StdControl.start() 
	{
		result_t ok1, ok2;
    
		ok1 = call UARTControl.start();
		ok2 = call RadioControl.start();
		call Leds.greenOn();
#ifdef REMOVE_COMM_OVERHEAD
		//call CC1000Control.SetRFPower(0xff);		
#endif 
		return rcombine(ok1, ok2);
	}

	command result_t StdControl.stop() 
	{
		result_t ok1, ok2;
    
	    ok1 = call UARTControl.stop();
	    ok2 = call RadioControl.stop();

		return rcombine(ok1, ok2);
	}

	TOS_MsgPtr receive(TOS_MsgPtr received, bool fromUART) 
	{
		TOS_MsgPtr nextReceiveBuffer = received;
		if ((!sendPending) )//&&(received->group == (TOS_AM_GROUP & 0xff))) 
		{      
			result_t ok;      
			nextReceiveBuffer = ourBuffer;
			ourBuffer = received;
			if (fromUART)
			{
				call Leds.redToggle();				
				ok = call DataMsg.send(TOS_BCAST_ADDR,sizeof(struct UbiMonMsg),received);
			}
			else
			{//from radio
				
				call Leds.greenToggle();
				received->addr = TOS_UART_ADDR;	
				ok = call UARTSend.send(received);
			}
			if (ok != FAIL)
			{			
				call Leds.redToggle();
				sendPending = TRUE;
			}
			else call Leds.yellowToggle();      			
		}
		return nextReceiveBuffer;
	}

	result_t sendDone(TOS_MsgPtr sent, result_t success) 
	{
		if(ourBuffer == sent)
		{
			if (success == FAIL) call Leds.yellowToggle();	  
			sendPending = FALSE;
		}
		return SUCCESS;
	}
  
	event TOS_MsgPtr ResetCounterMsg.receive(TOS_MsgPtr data)  
	{
		return receive(data, FALSE);
	}

   
	event TOS_MsgPtr UARTReceive.receive(TOS_MsgPtr data) 
	{
		return receive(data, TRUE);
	}
  
	event result_t UARTSend.sendDone(TOS_MsgPtr msg, result_t success) 
	{
		return sendDone(msg, success);
	}
  
	event result_t DataMsg.sendDone(TOS_MsgPtr msg, result_t success) 
	{
		return sendDone(msg, success);
	}

}  
