/*									Sensor type configuration
 * Authors:		Benny Lo
 * Created:			Dec 31, 2003
 * Last modified:	Dec 31, 2003
 *
 */

/* Constant for ECG sensor */
#ifndef SENSOR_TYPE_HEADER_INCLUDED
#define SENSOR_TYPE_HEADER_INCLUDED

#define MESSAGE_BS_REGISTER			1
#define MESSAGE_BS_ACKNOWLEDGE		2
#define MESSAGE_REGISTER			3
#define MESSAGE_ACKNOWLEDGE			4
#define MESSAGE_SENSOR_REGISTER		5
#define MESSAGE_SENSOR_ACKNOWLEDGE	6
#define MESSAGE_RSU_REQUEST_START	7
#define MESSAGE_RSU_START			8
#define MESSAGE_RSU_STOP			9
///////////////////////////////////////////////////////////////////////
//		Base Station - Constants
#define BS_UNIT_TYPE				0x0	//Base station
///////////////////////////////////////////////////////////////////////
//		ECG Sensing Remote Unit - Constants
///////////////////////////////////////////////////////////////////////
#define ECG_REMOTE_UNIT_TYPE		0x1	//ECG sensor unit
#define ECG_REMOTE_UNIT_NO_SENSOR	1	//no sensors included in the unit
#define ECG_SENSOR_1_TYPE			1	//ECG sensor
#define ECG_SENSOR_1_NAME			"ECG"//max 10 characters
#define ECG_SENSOR_1_SAMPLING_RATE	150 //150Hz  (max 255 Hz)
#define ECG_SENSOR_1_MIN_RANGE		400 
#define ECG_SENSOR_1_MAX_RANGE		600
#define ECG_SENSOR_1_MODE			0	//continuous =0 event trigger =1
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
//		AccTemp Sensing Remote Unit - Constants
///////////////////////////////////////////////////////////////////////
#define ACCTEMP_REMOTE_UNIT_TYPE		0x2	//AccelTemp sensor unit
#define ACCTEMP_REMOTE_UNIT_NO_SENSOR	3	//no sensors included in the unit
#define ACCTEMP_SENSOR_1_TYPE			2	//Accelerometer sensor
#define ACCTEMP_SENSOR_1_NAME			"AccelX"//max 10 characters
#define ACCTEMP_SENSOR_1_SAMPLING_RATE	25 //25Hz  (max 255 Hz)
#define ACCTEMP_SENSOR_1_MIN_RANGE		400 
#define ACCTEMP_SENSOR_1_MAX_RANGE		600
#define ACCTEMP_SENSOR_1_MODE			0	//continuous =0 event trigger =1
//---------------------------------------------------------------------------
#define ACCTEMP_SENSOR_2_TYPE			2	//Accelerometer sensor
#define ACCTEMP_SENSOR_2_NAME			"AccelY"//max 10 characters
#define ACCTEMP_SENSOR_2_SAMPLING_RATE	25 //25Hz  (max 255 Hz)
#define ACCTEMP_SENSOR_2_MIN_RANGE		400 
#define ACCTEMP_SENSOR_2_MAX_RANGE		600
#define ACCTEMP_SENSOR_2_MODE			0	//continuous =0 event trigger =1
//---------------------------------------------------------------------------
#define ACCTEMP_SENSOR_3_TYPE			3	//Temperature sensor
#define ACCTEMP_SENSOR_3_NAME			"Temp"//max 10 characters
#define ACCTEMP_SENSOR_3_SAMPLING_RATE	5 //25Hz  (max 255 Hz)
#define ACCTEMP_SENSOR_3_MIN_RANGE		200 
#define ACCTEMP_SENSOR_3_MAX_RANGE		1000
#define ACCTEMP_SENSOR_3_MODE			0	//continuous =0 event trigger =1
///////////////////////////////////////////////////////////////////////
typedef struct SensorTypeStruct
{
	uint8_t id;					//id of the sensor
	uint8_t Type;				//sensor type 
	uint8_t Mode;				
	uint8_t SamplingRate;		//sampling rate (max 255Hz)
	uint16_t MinRange,MaxRange;		
	char	Name[10];
} SensorType;

typedef struct RSU_Type_Struct
{	
	uint16_t SerialNo;	//serial no
	uint16_t Type;		//RSU type 
	uint16_t NoSensor;	//no sensors
	SensorType *Sensors;
} RSU_Type;

struct BS_RegisterMsg
{
	uint16_t msg_type;
	uint16_t BS_serialNo;
	uint16_t unit_type;
	uint16_t data[8];
	uint16_t crc;
};

struct RegisterMsg
{//for RSU
	uint16_t msg_type;	
	uint16_t serialNo;
	uint16_t unit_type;
	uint16_t no_sensors;
	uint16_t data[7];		
	uint16_t crc;
};

struct AcknowledgeMsg
{
	uint16_t msg_type;
	uint16_t serialNo;
	uint16_t NetworkID;
	uint16_t UnitID;
	uint16_t data[7];
	uint16_t crc;
};

struct SensorRegisterMsg
{//for Sensor
	uint16_t msg_type;
	uint16_t serialNo;
	uint8_t sensorID;
	uint8_t Type;
	uint8_t  Mode;
	uint8_t SamplingRate;
	uint16_t MinRange;
	uint16_t MaxRange;	
	char Name[10];	
	uint16_t crc;
};

struct SensorAcknowledgeMsg
{
	uint16_t msg_type;
	uint16_t serialNo;
	uint16_t sensorID;
	uint16_t data[8];
	uint16_t crc;
};

struct RequestToStartMsg
{
	uint16_t msg_type;
	uint16_t serialNo;
	uint16_t NetworkID;
	uint16_t UnitID;
	uint16_t data[7];
	uint16_t crc;
};

#endif	//ECG_SENSOR_HEADER_INCLUDED
