/*									UbiMon protocol
 * Authors:		Benny Lo
 * Created:			Dec 4, 2003
 * Last modified:	Dec 4, 2003
 *
 */

/* Packets used by UbiMon */
#ifndef UBIMONMSG_H_INCLUDED
#define UBIMONMSG_H_INCLUDED

enum {
	BUFFER_SIZE = 10
};

struct UbiMonMsg
{
    uint16_t sourceMoteID;
    uint16_t data[BUFFER_SIZE];	
#ifndef REMOVE_COMM_OVERHEAD
	uint16_t crc;
#endif
};

struct UbiMonResetMsg
{
    /* Empty payload! */
};

enum {
  AM_OSCOPEMSG = 10,/*packet size sent*/
  AM_OSCOPERESETMSG = 10/* packet size received*/
};

//#define USE_MICA2	//use Mica2
#undef USE_MICA2	//use Mica2dot

#define BASE_STATION	//for base station - ie genericbase
//#undef BASE_STATION //for remote sensing unit

#ifndef UBIMON_MSG_TYPE
#ifdef BASE_STATION
	#define UBIMON_MSG_TYPE	 32//10		//for generic base only (in case of Oscilloscope the no should be reversed)
	#define UBIMON_REC_MSG_TYPE 10//32  
#else 
	#define UBIMON_MSG_TYPE	 10		//for generic base only (in case of Oscilloscope the no should be reversed)
	#define UBIMON_REC_MSG_TYPE 32  
#endif
#endif

#endif //UBIMONMSG_H_INCLUDED

