package lambdas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UsingAnonymousClasses {
    
	  public static void main(String[] args) {

	    List<Integer> integers = new ArrayList<Integer>();
	    for(int i = 0; i < 10; i++) {
	      integers.add(i);
	    }

	    Transformer<Integer, Integer> t = new Transformer<Integer, Integer>() {
            @Override
            public Integer transform(Integer x) {
              return x*10;
            } 
	    };
	    
	    List<Integer> tenTimesBigger = Transformer.map(
                t, integers);
	    
	    System.out.println(tenTimesBigger);

	    List<Integer> hundredTimesBigger = Transformer.map(
                t, tenTimesBigger);

	    System.out.println(hundredTimesBigger);
	    
	    List<Float> floats = Transformer.map(
	                      new Transformer<Integer, Float>() {
	                    		@Override
	                    		public Float transform(Integer x) {
	                    			return new Float(x);
	                    		}
	                      }, integers);
	    System.out.println(floats);

	    List<List<Integer>> triples = Transformer.map(
	                      new Transformer<Integer, List<Integer>>() {
	                    		@Override
	                    		public List<Integer> transform(Integer x) {
	                    			return Arrays.asList(new Integer[] { x - 1, x, x + 1 });
	                    		}
	                      }, integers);
	    System.out.println(triples);
	  }

	}
