package lambdas;

import java.util.ArrayList;
import java.util.List;

public class UsingInterfaces {
    
	  public static void main(String[] args) {

	    List<Integer> integers = new ArrayList<Integer>();
	    for(int i = 0; i < 10; i++) {
	      integers.add(i);
	    }

	    List<Integer> tenTimesBigger = Transformer.map(
	                      new TimesTenTransformer(), integers);
	    System.out.println(tenTimesBigger);

	    List<Float> floats = Transformer.map(
	                      new IntegerToFloatTransformer(), integers);
	    System.out.println(floats);

	    List<List<Integer>> triples = Transformer.map(
	                      new IntegerToTripleTransformer(), integers);
	    System.out.println(triples);
	  }

	}
