package lambdas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Composition {
	
	public static <S, T, U> Transformer<S, U> compose(Transformer<S, T> t1,
			                                   Transformer<T, U> t2) {
		return (x -> t2.transform(t1.transform(x)));
	}
    
	  public static void main(String[] args) {

	    List<Integer> integers = new ArrayList<Integer>();
	    for(int i = 0; i < 10; i++) {
	      integers.add(i);
	    }
	    
	    Transformer<Integer, List<Integer>>
	    	timesTenAndTriple = compose(
	    			(x -> x*10),
	    			(x -> Arrays.asList(new Integer[] { x - 1, x, x + 1 })));
	    
	    List<List<Integer>> bigTriples = Transformer.map(timesTenAndTriple, integers);
	    System.out.println(bigTriples);
	    
	  }

	}
