package lambdas;

import java.util.ArrayList;
import java.util.List;

public interface Transformer<S, T> {

	  public T transform(S x);

	  public static <A, B> List<B> map(Transformer<A, B> transformer,
	                            List<A> input) {
	    List<B> result = new ArrayList<>();
	    for(A a : input) {
	      result.add(transformer.transform(a));
	    }
	    return result;
	  }

}

