package lambdas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UsingLambdas {
    
	  public static void main(String[] args) {

	    List<Integer> integers = new ArrayList<Integer>();
	    for(int i = 0; i < 10; i++) {
	      integers.add(i);
	    }

	    List<Integer> tenTimesBigger = Transformer.map(
                x -> x*10, integers);
	    System.out.println(tenTimesBigger);

	    List<Float> floats = Transformer.map(
	            Float::new, integers);
	    System.out.println(floats);

	    List<List<Integer>> triples = Transformer.map(
	            x -> Arrays.asList(new Integer[] { x - 1, x, x + 1 }), integers);
	    System.out.println(triples);
	  }

	}
