package lambdas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UsingMethodReferences {
    
	  private static Integer timesTen(Integer x) {
		  return x * 10;
	  }
	  
	  private static List<Integer> toTriple(Integer x) {
		  return Arrays.asList(new Integer[] { x - 1, x, x + 1 });
	  }
	  	
	  public static void main(String[] args) {

	    List<Integer> integers = new ArrayList<Integer>();
	    for(int i = 0; i < 10; i++) {
	      integers.add(i);
	    }

	    List<Integer> tenTimesBigger = Transformer.map(
	    		UsingMethodReferences::timesTen, integers);
	    System.out.println(tenTimesBigger);

	    List<Float> floats = Transformer.map(
	            Float::new, integers);
	    System.out.println(floats);

	    List<List<Integer>> triples = Transformer.map(
	    		UsingMethodReferences::toTriple, integers);
	    System.out.println(triples);
	  }

	}
