//
// blocking_tcp_echo_client.cpp
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// Copyright (c) 2003-2011 Christopher M. Kohlhoff (chris at kohlhoff dot com)
//
// Distributed under the Boost Software License, Version 1.0. (See accompanying
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//

#include <cstdlib>
#include <cstring>
#include <iostream>
#include <boost/asio.hpp>

using boost::asio::ip::tcp;

enum { max_length = 1024 };

int main(int argc, char* argv[])
{
    try
    {
        if (argc != 3)
        {
            std::cerr << "Usage: blocking_tcp_echo_client <host> <port>\n";
            return 1;
        }

        {
            boost::asio::io_service io_service;

            tcp::resolver resolver(io_service);
            tcp::resolver::query query(tcp::v4(), argv[1], argv[2]);
            tcp::resolver::iterator iterator = resolver.resolve(query);

            tcp::socket s(io_service);
            s.connect(*iterator);

            std::string msg1("Hello "), msg2("World!\n"), msg3("exit\n");

            boost::asio::write(s, boost::asio::buffer(msg1, msg1.size()));
            std::cout << msg1 << " sendet" << std::endl;
            sleep(5);
            boost::asio::write(s, boost::asio::buffer(msg2, msg2.size()));
            std::cout << msg2 << " sendet" << std::endl;
            sleep(5);
            boost::asio::write(s, boost::asio::buffer(msg3, msg3.size()));
            std::cout << msg3 << " sendet" << std::endl;
        }

        std::cout << "Done" << std::endl;
    }
    catch (std::exception& e)
    {
        std::cerr << "Exception: " << e.what() << "\n";
    }

    return 0;
}
