/*
 * Decompiled with CFR 0.152.
 */
package koala;

import java.io.Serializable;
import koala.KoalaVector;

public class KoalaLocation
implements Serializable {
    public static final int UNKNOWN_HEADING = 999;
    public int imageX;
    public int imageY;
    public int x;
    public int y;
    public int heading = 999;

    public KoalaLocation() {
    }

    public KoalaLocation(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public KoalaLocation(int n, int n2, int n3) {
        this(n, n2);
        this.heading = n3;
    }

    public int reliability() {
        return 480000 - (this.imageX * this.imageX + this.imageY * this.imageY);
    }

    public KoalaVector getVectorTo(KoalaLocation koalaLocation) {
        return new KoalaVector(koalaLocation.x - this.x, koalaLocation.y - this.y);
    }

    public int getRotationTo(KoalaLocation koalaLocation) {
        if (this.heading == 999) {
            return 999;
        }
        int n = this.getVectorTo(koalaLocation).direction() - this.heading;
        if (n > 180) {
            n -= 360;
        } else if (n < -180) {
            n += 360;
        }
        return n;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + "; " + this.heading + ")";
    }
}

