/*
 * Decompiled with CFR 0.152.
 */
package koala.motion;

import com.hopstepjump.backbone.api.req;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import koala.KoalaLocation;
import koala.KoalaVector;
import koala.motion.GoTo;
import koala.motion.MotionController;
import koala.motion.MotionSource;
import koala.remote.LocationServer;
import koala.task.AchievedGoalEvent;
import koala.task.FailedEvent;
import koala.task.KoalaTask;
import koala.task.NetworkFailedEvent;
import koala.task.TargetOutOfRangeEvent;

public class GoToTask
extends KoalaTask
implements MotionSource,
GoTo {
    @req(value="controller")
    public transient MotionController controller;
    @req(value="locator")
    public transient LocationServer locator;
    private volatile transient KoalaLocation target;
    private String targetName;
    private boolean iAmRed;
    private String robotName;
    private int threshold = 150;
    private boolean succeeded = false;
    private volatile transient KoalaVector direction = new KoalaVector(0.0, 0.0);

    public GoToTask() {
        try {
            this.iAmRed = System.getProperty("robotColour").equals("red");
            this.robotName = System.getProperty("java.rmi.server.hostname");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Thread thread = new Thread(){

            public void run() {
                while (GoToTask.this.controller == null) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                }
                System.out.println("GoToTask: Registering with motion controller.");
                GoToTask.this.controller.registerMotionSource(GoToTask.this, 5);
            }
        };
        thread.start();
    }

    public void initialise(Object[] objectArray) throws IllegalArgumentException {
        if (objectArray.length == 2 && objectArray[0] instanceof Integer && objectArray[1] instanceof Integer) {
            this.target = new KoalaLocation((Integer)objectArray[0], (Integer)objectArray[1]);
        } else if (objectArray.length == 1 && objectArray[0] instanceof String) {
            this.targetName = (String)objectArray[0];
            try {
                this.target = this.locator.getLocation(this.targetName);
            }
            catch (RemoteException remoteException) {
                System.err.println("GoToTask exception: " + remoteException.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Argument list must match (Integer x, Integer y) or (String locName).");
        }
    }

    public GoToTask(int n, int n2) {
        this(n, n2, 50);
    }

    public GoToTask(int n, int n2, int n3) {
        this();
        this.target = new KoalaLocation(n, n2);
        this.threshold = n3;
    }

    public GoToTask(String string) {
        this();
        this.targetName = string;
        try {
            this.target = this.locator.getLocation(string);
        }
        catch (RemoteException remoteException) {
            System.err.println("GoToTask exception: " + remoteException.getMessage());
        }
    }

    public boolean goTo(String string) throws RemoteException {
        System.out.println("CALLED BY THE POWER OF GREYSKULL");
        try {
            this.target = this.locator.getLocation(string);
        }
        catch (RemoteException remoteException) {
            System.err.println("GoToTask exception: " + remoteException.getMessage());
        }
        this.succeeded = false;
        this.running = true;
        this.run();
        System.out.println("I have the power!");
        return this.succeeded;
    }

    public void updateTarget(KoalaLocation koalaLocation) {
        if (koalaLocation != null) {
            this.target = koalaLocation;
        }
    }

    protected boolean succeeded(KoalaLocation koalaLocation) {
        if (this.targetName != null) {
            try {
                return this.locator.robotInLocation(this.robotName, this.targetName);
            }
            catch (RemoteException remoteException) {
                System.err.println("GoToTask exception: " + remoteException.getMessage());
            }
        }
        return Math.abs(koalaLocation.x - this.target.x) < this.threshold && Math.abs(koalaLocation.y - this.target.y) < this.threshold;
    }

    public void run() {
        KoalaLocation koalaLocation = null;
        Object var3_2 = null;
        System.out.println("Going to " + this.target.x + ", " + this.target.y);
        try {
            if (!this.locator.canSee(new KoalaLocation(this.target.x, this.target.y))) {
                System.out.println("GoToTask: Out of range");
                this.halt(false);
                this.eventHappened(new TargetOutOfRangeEvent(this));
            }
        }
        catch (RemoteException remoteException) {
            System.err.println("GoToTask exception: " + remoteException.getMessage());
        }
        while (this.running) {
            try {
                koalaLocation = this.locator.getRobotLocation(this.iAmRed);
                System.out.println("G: loc = " + koalaLocation);
                if (var3_2 != null && koalaLocation.heading == 999) {
                    System.out.println("GoToTask: Fudging heading");
                    koalaLocation.heading = var3_2.heading;
                }
                if (koalaLocation == null || koalaLocation.heading == 999) {
                    System.out.println("GoToTask: Failio");
                    this.halt(false);
                    this.eventHappened(new FailedEvent(this));
                } else if (this.succeeded(koalaLocation)) {
                    System.out.println("GoToTask: Succeedio");
                    this.halt(true);
                    this.eventHappened(new AchievedGoalEvent(this));
                } else {
                    KoalaVector koalaVector = koalaLocation.getVectorTo(this.target);
                    int n = koalaVector.direction() - koalaLocation.heading;
                    this.direction = KoalaVector.createFromMagAndDir(5.0, n);
                }
                Thread.sleep(250L);
            }
            catch (RemoteException remoteException) {
                this.halt(false);
                this.eventHappened(new NetworkFailedEvent(this, "LocationServer", remoteException.getClass().getName()));
            }
            catch (InterruptedException interruptedException) {
                System.out.println("GoToTask interrupted.");
            }
        }
    }

    public void halt(boolean bl) {
        this.succeeded = bl;
        this.direction = new KoalaVector(0.0, 0.0);
        this.running = false;
    }

    public KoalaVector getDirection() {
        return this.direction;
    }

    public class RemoteProxy
    extends UnicastRemoteObject
    implements GoTo {
        public boolean goTo(String string) throws RemoteException {
            return GoToTask.this.goTo(string);
        }
    }
}

