/*
 * Decompiled with CFR 0.152.
 */
package koala.motion;

import com.hopstepjump.backbone.DynamicBackbone;
import com.hopstepjump.backbone.api.TranquilComponent;
import com.hopstepjump.backbone.api.req;
import java.rmi.RemoteException;
import java.util.Vector;
import koala.KoalaLocation;
import koala.KoalaVector;
import koala.motion.Map;
import koala.motion.MotionController;
import koala.motion.MotionSource;
import koala.remote.LocationServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticObstacleAvoider
implements MotionSource,
TranquilComponent {
    @req(value="controller")
    public MotionController controller;
    @req(value="locator")
    public LocationServer locator;
    @req(value="map")
    public Map map;
    private boolean iAmRed;

    public StaticObstacleAvoider() {
        try {
            this.iAmRed = System.getProperty("robotColour").equals("red");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void startComponent() {
        System.out.println("StaticObstacleAvoider: Registering with motion controller.");
        this.controller.registerMotionSource(this, 50);
    }

    public void stopComponent() {
    }

    public boolean transactionInProgress() {
        return false;
    }

    public Vector<Object> getReusedComponents() {
        return null;
    }

    public void setFailureHandler(DynamicBackbone.RemoteDynamicBackbone remoteDynamicBackbone) {
    }

    public void addObstacle(KoalaLocation koalaLocation) {
        this.addObstacle(koalaLocation, 100);
    }

    public void addObstacle(KoalaLocation koalaLocation, int n) {
        this.map.addLocation(new Map.MapLocation(koalaLocation.x, koalaLocation.y, "obstacle", n));
    }

    @Override
    public KoalaVector getDirection() {
        int n;
        KoalaLocation koalaLocation = null;
        try {
            koalaLocation = this.locator.getRobotLocation(this.iAmRed);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        if (koalaLocation == null || koalaLocation.heading == 999) {
            return new KoalaVector(0.0, 0.0);
        }
        double d = 0.0;
        double d2 = 0.0;
        System.out.println("Static: " + this.map.getNLocations() + " obstacles");
        for (n = 0; n < this.map.getNLocations(); ++n) {
            Map.MapLocation mapLocation = this.map.getLocation(n);
            KoalaVector koalaVector = mapLocation.getVectorTo(koalaLocation);
            System.out.println("Static: " + mapLocation + " distance " + koalaVector.magnitude());
            if (!(koalaVector.magnitude() < (double)mapLocation.radius)) continue;
            System.out.println("Static: Within threshold of " + mapLocation);
            d += koalaVector.x;
            d2 += koalaVector.y;
        }
        if (d == 0.0 && d2 == 0.0) {
            return new KoalaVector(0.0, 0.0);
        }
        n = new KoalaVector(d, d2).direction() - koalaLocation.heading;
        return KoalaVector.createFromMagAndDir(2.0, n);
    }
}

