/*
 * Decompiled with CFR 0.152.
 */
package koala.motion;

import com.hopstepjump.backbone.DynamicBackbone;
import com.hopstepjump.backbone.api.TranquilComponent;
import com.hopstepjump.backbone.api.req;
import java.awt.Color;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;
import koala.KoalaCamera;
import koala.KoalaImage;
import koala.KoalaLocation;
import koala.KoalaVector;
import koala.motion.DoorLocator;
import koala.motion.MultipleGoTo;
import koala.remote.LocationServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualDoorLocator
implements DoorLocator,
TranquilComponent {
    @req(value="goto")
    public transient MultipleGoTo goTo;
    @req(value="camera")
    public transient KoalaCamera camera;
    @req(value="locator")
    public transient LocationServer locator;

    public void startComponent() {
    }

    public void stopComponent() {
    }

    public boolean transactionInProgress() {
        return false;
    }

    public Vector<Object> getReusedComponents() {
        return null;
    }

    public void setFailureHandler(DynamicBackbone.RemoteDynamicBackbone remoteDynamicBackbone) {
    }

    @Override
    public void findDoor(KoalaLocation koalaLocation, KoalaVector koalaVector) throws RemoteException {
        boolean bl = true;
        KoalaLocation koalaLocation2 = koalaLocation;
        koalaVector.scale(50.0);
        this.goTo.goTo(koalaLocation);
        while (bl) {
            KoalaImage koalaImage = new KoalaImage(this.camera.getImage(), 640, 480);
            koalaImage.applyRedThreshold(90, 1.9, 1.65);
            if (koalaImage.getLargestBlob(Color.red, 13000) != null) {
                System.out.println("VisualDoorLocator: FOUND THE RED DOOR");
                bl = false;
            } else if (this.goTo.nWaypoints() == 0) {
                koalaLocation2.x = (int)((double)koalaLocation2.x + koalaVector.x);
                koalaLocation2.y = (int)((double)koalaLocation2.y + koalaVector.y);
                if (!this.locator.canSee(koalaLocation2)) {
                    System.out.println("VisualDoorLocator: Next waypoint off the map");
                    bl = false;
                } else {
                    System.out.println("VisualDoorLocator: Next: " + koalaLocation2);
                    this.goTo.goTo(koalaLocation2);
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.goTo.removeAllWaypoints();
    }

    public class RemoteProxy
    extends UnicastRemoteObject
    implements DoorLocator {
        public void findDoor(KoalaLocation koalaLocation, KoalaVector koalaVector) throws RemoteException {
            VisualDoorLocator.this.findDoor(koalaLocation, koalaVector);
        }
    }
}

