/*
 * Decompiled with CFR 0.152.
 */
package koala.motion;

import com.hopstepjump.backbone.DynamicBackbone;
import com.hopstepjump.backbone.api.TranquilComponent;
import com.hopstepjump.backbone.api.req;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;
import koala.KoalaCamera;
import koala.KoalaImage;
import koala.KoalaVector;
import koala.motion.LineFollower;
import koala.motion.MotionController;
import koala.motion.MotionSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualLineFollower
implements MotionSource,
LineFollower,
TranquilComponent {
    @req(value="controller")
    public transient MotionController controller;
    @req(value="camera")
    public transient KoalaCamera camera;
    private volatile ZThread zThread;
    private volatile transient KoalaVector direction = new KoalaVector(0.0, 0.0);

    public void startComponent() {
        System.out.println("VisualLineFollower: Registering with motion controller.");
        this.controller.registerMotionSource(this, 5);
    }

    public void stopComponent() {
        this.controller.deregisterMotionSource(this);
        try {
            this.stopLineFollowing();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean transactionInProgress() {
        return false;
    }

    public Vector<Object> getReusedComponents() {
        return null;
    }

    public void setFailureHandler(DynamicBackbone.RemoteDynamicBackbone remoteDynamicBackbone) {
    }

    @Override
    public void startLineFollowing() throws RemoteException {
        if (this.zThread != null) {
            this.zThread.halt();
        }
        this.zThread = new ZThread();
        this.zThread.start();
    }

    @Override
    public void stopLineFollowing() throws RemoteException {
        if (this.zThread != null) {
            this.zThread.halt();
        }
    }

    @Override
    public KoalaVector getDirection() {
        return this.direction;
    }

    public class ZThread
    extends Thread {
        private volatile boolean running = true;

        public void run() {
            while (this.running) {
                int n;
                int n2;
                int[] nArray = VisualLineFollower.this.camera.getImage();
                int[] nArray2 = new int[76800];
                for (int i = 0; i < 240; ++i) {
                    for (n2 = 0; n2 < 320; ++n2) {
                        nArray2[i * 320 + n2] = nArray[i * 2 * 320 + n2];
                    }
                }
                KoalaImage koalaImage = new KoalaImage(nArray2, 320, 240);
                koalaImage.applyGreyThreshold(80);
                n2 = 0;
                int n3 = 0;
                for (n = 0; n < 240; ++n) {
                    int n4;
                    for (n4 = 0; n4 < 160; ++n4) {
                        if (koalaImage.pixels[n * 320 + n4] != 0) continue;
                        ++n2;
                    }
                    for (n4 = 160; n4 < 320; ++n4) {
                        if (koalaImage.pixels[n * 320 + n4] != 0) continue;
                        ++n3;
                    }
                }
                n = (n2 - n3) / 213;
                if (n < 0) {
                    n = 360 + n;
                }
                System.out.println("LINE: [" + n2 + " || " + n3 + " ]=" + n);
                VisualLineFollower.this.direction = KoalaVector.createFromMagAndDir(5.0, n);
                System.out.println("LINE: " + VisualLineFollower.this.direction);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void halt() {
            this.running = false;
            if (Thread.currentThread() != VisualLineFollower.this.zThread) {
                try {
                    VisualLineFollower.this.zThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            VisualLineFollower.this.direction = new KoalaVector(0.0, 0.0);
        }
    }

    public class RemoteProxy
    extends UnicastRemoteObject
    implements LineFollower {
        public void startLineFollowing() throws RemoteException {
            VisualLineFollower.this.startLineFollowing();
        }

        public void stopLineFollowing() throws RemoteException {
            VisualLineFollower.this.stopLineFollowing();
        }
    }
}

