/*
 * Decompiled with CFR 0.152.
 */
package koala.planning;

import com.hopstepjump.backbone.RemoteBackbone;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Vector;
import koala.planning.InterpreterException;
import koala.planning.LocalPlanInterpreter;
import koala.planning.Plan;
import koala.planning.PlanCondition;
import koala.planning.PlanProposition;
import koala.planning.PlanRule;

public abstract class AbstractLocalPlanInterpreter
implements LocalPlanInterpreter {
    protected boolean planDone = false;
    protected Map<String, String> peers;

    protected boolean evaluateRemoteProposition(PlanProposition planProposition) throws InterpreterException, RemoteException {
        System.out.println("CANNOT DETERMINE " + planProposition + " LOCALLY");
        String string = this.peers.get(planProposition.predicate.elementAt(0));
        if (string == null) {
            System.out.println("CANNOT DETERMINE " + planProposition + " REMOTELY");
            throw new InterpreterException("Proposition " + planProposition + " cannot be evaluated by peers " + this.peers);
        }
        System.out.println(planProposition + " evaluated by " + string);
        try {
            RemoteBackbone remoteBackbone = (RemoteBackbone)Naming.lookup("rmi://" + string + "/remotebackbone");
            LocalPlanInterpreter localPlanInterpreter = (LocalPlanInterpreter)remoteBackbone.getInterfaceInstance("koala.planning.LocalPlanInterpreter");
            return localPlanInterpreter.evaluateProposition(planProposition);
        }
        catch (NotBoundException notBoundException) {
            throw new InterpreterException("Peer " + string + " cannot be contacted.");
        }
        catch (MalformedURLException malformedURLException) {
            throw new InterpreterException("Peer " + string + " cannot be contacted.");
        }
    }

    public void execute(final Plan plan) throws InterpreterException, RemoteException {
        Thread thread = new Thread(){

            public void run() {
                try {
                    while (!AbstractLocalPlanInterpreter.this.planDone) {
                        if (AbstractLocalPlanInterpreter.this.executeStep(plan)) continue;
                        System.out.println("... State not in plan ...");
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    System.out.println("DONE");
                }
                catch (Exception exception) {
                    System.out.println("FAILED " + exception.getMessage());
                }
            }
        };
        thread.start();
    }

    public boolean executeStep(Plan plan) throws InterpreterException, RemoteException {
        boolean bl = false;
        for (int i = 0; !bl && i < plan.size(); ++i) {
            if (!this.evaluateCondition(((PlanRule)plan.elementAt((int)i)).condition)) continue;
            System.out.println("TRUE:" + ((PlanRule)plan.elementAt((int)i)).condition);
            Vector<String> vector = ((PlanRule)plan.elementAt((int)i)).action;
            if (vector.elementAt(0).equals("done")) {
                System.out.println("Done.");
                this.planDone = true;
            } else {
                this.performAction(vector);
            }
            bl = true;
        }
        return bl;
    }

    public boolean evaluateCondition(PlanCondition planCondition) throws InterpreterException, RemoteException {
        for (PlanProposition planProposition : planCondition) {
            if (!this.evaluateProposition(planProposition)) {
                System.out.println("- was false");
                return false;
            }
            System.out.println("- was true");
        }
        return true;
    }

    protected static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

