/*
 * Decompiled with CFR 0.152.
 */
package koala.planning;

import com.hopstepjump.backbone.RemoteBackbone;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import java.util.Vector;
import koala.KoalaLocation;
import koala.motion.GoTo;
import koala.planning.AbstractLocalPlanInterpreter;
import koala.planning.InterpreterException;
import koala.planning.LocalPlanInterpreter;
import koala.planning.Plan;
import koala.planning.PlanProposition;
import koala.remote.LocationServer;
import koala.task.Surveyor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KoalaPlanInterpreter
extends AbstractLocalPlanInterpreter {
    private boolean iAmRed;
    private Vector<String> actionTrace = new Vector();
    private RemoteBackbone localBackbone;
    private LocationServer locator;
    private boolean foundDepot = false;
    private boolean loaded = false;
    private boolean searching = false;

    @Override
    public void execute(Plan plan, Map<String, String> map) throws InterpreterException, RemoteException {
        this.peers = map;
        try {
            this.iAmRed = System.getProperty("robotColour").equals("red");
        }
        catch (Exception exception) {
            System.err.println("KoalaPlanInterpreter: Missing robotColour parameter");
        }
        try {
            this.localBackbone = (RemoteBackbone)Naming.lookup("remotebackbone");
        }
        catch (Exception exception) {
            System.err.println("KoalaPlanInterpreter: CANNOT GET LOCAL BACKBONE");
        }
        if (this.localBackbone != null) {
            if (plan.containsProposition("at_loc1")) {
                this.locator = (LocationServer)this.localBackbone.getInterfaceInstance("koala.remote.LocationServer");
            }
            this.execute(plan);
        }
    }

    @Override
    public boolean evaluateProposition(PlanProposition planProposition) throws InterpreterException, RemoteException {
        System.out.println(planProposition);
        if (planProposition.operator.equals("=")) {
            String string = planProposition.predicate.elementAt(0);
            if (string.equals("found_depot")) {
                return this.foundDepot == planProposition.value.equals("1");
            }
            if (string.equals("at_loc1")) {
                KoalaLocation koalaLocation = this.locator.getRobotLocation(this.iAmRed);
                return this.locator.isNear(koalaLocation, "loc1") == planProposition.value.equals("1");
            }
            if (string.equals("koala1_loaded")) {
                return planProposition.value.equals("1") == this.loaded;
            }
            if (string.equals("searching")) {
                return planProposition.value.equals("1") == this.searching;
            }
            return this.evaluateRemoteProposition(planProposition);
        }
        throw new InterpreterException("Proposition " + planProposition + " cannot be evaluated here.");
    }

    @Override
    public void performAction(Vector<String> vector) throws InterpreterException, RemoteException {
        System.out.println("ACTION:" + vector);
        String string = vector.elementAt(0);
        this.actionTrace.add(string);
        if (string.equals("find_depot")) {
            System.out.println("Trying to find the depot");
            final Surveyor surveyor = (Surveyor)this.localBackbone.getInterfaceInstance("koala.task.Surveyor");
            this.searching = true;
            Thread thread = new Thread(){

                public void run() {
                    try {
                        surveyor.search(true);
                        KoalaPlanInterpreter.this.foundDepot = surveyor.found();
                        KoalaPlanInterpreter.this.searching = false;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        KoalaPlanInterpreter.this.componentFailure("find_depot", exception);
                    }
                }
            };
            thread.start();
            KoalaPlanInterpreter.sleep(10000L);
        } else if (string.length() > 18 && string.substring(0, 18).equals("start_koala1_goto_")) {
            System.out.println("Moving");
            String string2 = string.substring(18);
            System.out.println(" Target: " + string2);
            KoalaLocation koalaLocation = this.locator.getLocation(string2);
            if (koalaLocation == null) {
                throw new InterpreterException(string2 + " is not a known location.");
            }
            try {
                GoTo goTo = (GoTo)this.localBackbone.getInterfaceInstance("koala.motion.GoTo");
                if (!goTo.goTo(string2)) {
                    this.componentFailure(string, null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.componentFailure(string, exception);
            }
        }
        throw new InterpreterException("Action " + string + " cannot be executed here.");
    }

    private void componentFailure(String string, Exception exception) {
        if (exception == null) {
            System.out.println("FAILED (component failure on action " + string + ")");
        } else {
            System.out.println("FAILED (component failure on action " + string + ", " + exception.getClass().getName() + ")");
        }
        for (String string2 : this.actionTrace) {
            System.out.println("       " + string2);
        }
        System.exit(-1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RemoteProxy
    extends UnicastRemoteObject
    implements LocalPlanInterpreter {
        @Override
        public void execute(Plan plan, Map<String, String> map) throws InterpreterException, RemoteException {
            KoalaPlanInterpreter.this.execute(plan, map);
        }

        @Override
        public boolean evaluateProposition(PlanProposition planProposition) throws InterpreterException, RemoteException {
            return KoalaPlanInterpreter.this.evaluateProposition(planProposition);
        }

        @Override
        public void performAction(Vector<String> vector) throws InterpreterException, RemoteException {
            KoalaPlanInterpreter.this.performAction(vector);
        }
    }
}

