/*
 * Decompiled with CFR 0.152.
 */
package koala.task;

import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import koala.Koala;
import koala.KoalaLocation;
import koala.remote.LocationServer;
import koala.task.AchievedGoalEvent;
import koala.task.FailedEvent;
import koala.task.GoToTask;
import koala.task.KoalaTask;
import koala.task.KoalaTaskEvent;
import koala.task.KoalaTaskListener;
import koala.task.NetworkFailedEvent;

public class AdvancedFollowingTask
extends KoalaTask {
    private transient GoToTask goTo = null;
    private final transient String locatorName = System.getProperty("centralControl") == null ? "madeira" : System.getProperty("centralControl");

    public AdvancedFollowingTask(Koala koala) {
        super(koala);
    }

    public AdvancedFollowingTask() {
    }

    public void initialise(Object[] objectArray) throws IllegalArgumentException {
    }

    private boolean near(int n, int n2) {
        return Math.abs(n - n2) < 400;
    }

    public void run() {
        LocationServer locationServer = null;
        boolean bl = false;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            locationServer = (LocationServer)Naming.lookup("rmi://" + this.locatorName + "/location");
        }
        catch (RemoteException remoteException) {
            this.eventHappened(new NetworkFailedEvent(this, this.locatorName, remoteException.getClass().getName()));
            this.halt();
        }
        catch (NotBoundException notBoundException) {
            this.eventHappened(new NetworkFailedEvent(this, this.locatorName, notBoundException.getClass().getName()));
            this.halt();
        }
        catch (Exception exception) {
            this.halt();
            exception.printStackTrace();
        }
        bl = false;
        try {
            while (this.running) {
                KoalaLocation koalaLocation = locationServer.getRobotLocation(!bl);
                KoalaLocation koalaLocation2 = locationServer.getRobotLocation(bl);
                if (koalaLocation == null || koalaLocation2 == null) {
                    this.eventHappened(new FailedEvent(this));
                    this.halt();
                    continue;
                }
                if (this.near(koalaLocation.x, koalaLocation2.x) && this.near(koalaLocation.y, koalaLocation2.y)) {
                    this.eventHappened(new AchievedGoalEvent(this));
                    this.halt();
                    continue;
                }
                if (this.goTo != null) {
                    this.goTo.updateTarget(koalaLocation);
                } else {
                    this.goTo = new GoToTask(koalaLocation.x, koalaLocation.y);
                    this.goTo.setRobot(this.motors, this.sensors, this.longRangeSensors);
                    this.goTo.addListener(new KoalaTaskListener(){

                        public void eventHappened(KoalaTaskEvent koalaTaskEvent) {
                            System.out.println("GoTo event: " + koalaTaskEvent);
                            if (koalaTaskEvent instanceof FailedEvent) {
                                AdvancedFollowingTask.this.halt();
                                AdvancedFollowingTask.this.propagateEvent(koalaTaskEvent);
                            } else if (koalaTaskEvent instanceof AchievedGoalEvent) {
                                AdvancedFollowingTask.this.halt();
                                AdvancedFollowingTask.this.propagateEvent(koalaTaskEvent);
                            }
                        }
                    });
                    this.goTo.start();
                }
                Thread.sleep(2000L);
            }
        }
        catch (RemoteException remoteException) {
            this.eventHappened(new NetworkFailedEvent(this, this.locatorName, remoteException.getClass().getName()));
            this.halt();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Sleep interrupted");
            this.halt();
        }
    }

    public void halt() {
        System.out.println("Haltestelle");
        if (this.goTo != null) {
            this.goTo.halt();
        }
        super.halt();
    }

    private void propagateEvent(KoalaTaskEvent koalaTaskEvent) {
        this.eventHappened(koalaTaskEvent);
    }
}

