/*
 * Decompiled with CFR 0.152.
 */
package koala.task;

import com.hopstepjump.backbone.api.req;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Vector;
import koala.Koala;
import koala.KoalaLongRangeSensors;
import koala.KoalaMotors;
import koala.KoalaSensors;
import koala.task.KoalaTaskEvent;
import koala.task.KoalaTaskListener;

public abstract class KoalaTask
extends Thread
implements Serializable {
    @req(value="motors")
    public transient KoalaMotors motors;
    @req(value="sensors")
    public transient KoalaSensors sensors;
    @req(value="lrsensors")
    public transient KoalaLongRangeSensors longRangeSensors;
    protected volatile transient boolean running;
    protected transient Vector<KoalaTaskListener> listeners = null;

    public KoalaTask() {
    }

    public abstract void initialise(Object[] var1) throws IllegalArgumentException;

    public void setRobot(KoalaMotors koalaMotors, KoalaSensors koalaSensors, KoalaLongRangeSensors koalaLongRangeSensors) {
        this.motors = koalaMotors;
        this.sensors = koalaSensors;
        this.longRangeSensors = koalaLongRangeSensors;
    }

    public void setRobot(Koala koala) {
        this.setRobot(koala, koala, koala);
    }

    public KoalaTask(Koala koala) {
        this.setRobot(koala, koala, koala);
    }

    public void start() {
        this.running = true;
        super.start();
    }

    public void halt() {
        this.running = false;
    }

    public void addListener(KoalaTaskListener koalaTaskListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(koalaTaskListener);
    }

    protected void eventHappened(KoalaTaskEvent koalaTaskEvent) {
        if (this.listeners != null) {
            for (KoalaTaskListener koalaTaskListener : this.listeners) {
                try {
                    koalaTaskListener.eventHappened(koalaTaskEvent);
                }
                catch (RemoteException remoteException) {}
            }
        }
    }
}

