/*
 * Decompiled with CFR 0.152.
 */
package koala.task;

import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import koala.Koala;
import koala.KoalaLocation;
import koala.KoalaMotorController;
import koala.KoalaSensorReading;
import koala.remote.LocationServer;
import koala.task.KoalaTask;

public class RandomSearchTask
extends KoalaTask {
    private transient LocationServer locator;
    private boolean iAmRed;
    private final transient String locatorName = System.getProperty("centralControl") == null ? "madeira" : System.getProperty("centralControl");

    public RandomSearchTask() {
    }

    public RandomSearchTask(Koala koala) {
        this.setRobot(koala);
    }

    public void initialise(Object[] objectArray) throws IllegalArgumentException {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            this.locator = (LocationServer)Naming.lookup("rmi://" + this.locatorName + "/location");
            this.iAmRed = System.getProperty("robotColour").equals("red");
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    public void setRobot(Koala koala) {
        super.setRobot(new KoalaMotorController(koala), koala, koala);
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            this.locator = (LocationServer)Naming.lookup("rmi://" + this.locatorName + "/location");
            this.iAmRed = System.getProperty("robotColour").equals("red");
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    public void run() {
        while (this.running) {
            if (this.foundTarget()) {
                this.halt();
            } else if (this.obstacle()) {
                if (Math.random() > 0.5) {
                    this.motors.rotate(90.0);
                } else {
                    this.motors.rotate(-90.0);
                }
            } else {
                this.motors.setSpeed(30, 30);
            }
            try {
                Thread.sleep(250L);
            }
            catch (Exception exception) {
                this.halt();
            }
        }
    }

    private boolean obstacle() {
        KoalaSensorReading koalaSensorReading = this.sensors.readProximitySensors();
        for (int i = 0; i < 3; ++i) {
            if (koalaSensorReading.leftSensors[i] <= 300 && koalaSensorReading.rightSensors[i] <= 300) continue;
            return true;
        }
        return false;
    }

    private boolean near(int n, int n2) {
        return n + 250 > n2 && n - 250 < n2;
    }

    private boolean foundTarget() {
        try {
            KoalaLocation koalaLocation = this.locator.getRobotLocation(this.iAmRed);
            KoalaLocation koalaLocation2 = this.locator.getRobotLocation(!this.iAmRed);
            return this.near(koalaLocation.x, koalaLocation2.x) && this.near(koalaLocation.y, koalaLocation2.y);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void halt() {
        this.running = false;
        this.motors.setSpeed(0, 0);
    }
}

