% THIS SCRIPT RUNS THE EXPERIMENTS

clear

% varying parameters
vusers = [500 1000 2000 5000 7500 10000];
vrt = [71 72 73 74 75 100 200 300];
va = [0.9 0.92 0.95 0.97 0.99 0.999];

% fixed parameters
users = 2000;
rt = 100;
a = 0.95;
seed = 1;

expset = 1:30;
refUsers = 2000;
refRT = 100;
refRecover = 100;

expUsers = [1000 3000 4000 5000];
expRT = [30 40 50 75 100 500];
expRecover = [0 300 600 900];

for ii=expset
	disp(['RUNNING EXPERIMENT SET ' num2str(ii) ' OF ' num2str(max(expset))]);
	
	disp('RUNNING REFERENCE EXPERIMENT USING HEURISTIC');
	experiment(refUsers, refRT, 'heuristic', refRecover, ii);
	
	disp('RUNNING REFERENCE EXPERIMENT USING FMINCON');
	%experiment(refUsers, refRT, 'fmincon', refRecover, ii);
	
	count=0;
	for jj=expUsers
		count = count+1;
		disp(['USERS HEURISTIC EXPERIMENT ' num2str(count) ' OF ' num2str(length(expUsers))]);
		experiment(jj, refRT, 'heuristic', refRecover, ii);
		
		disp(['USERS FMINCON EXPERIMENT ' num2str(count) ' OF ' num2str(length(expUsers))]);
		%experiment(jj, refRT, 'fmincon', refRecover, ii);
	end
	
	count=0;
	for jj=expRT
		count = count+1;
		disp(['RT HEURISTIC EXPERIMENT ' num2str(count) ' OF ' num2str(length(expRT))]);
		experiment(refUsers, jj, 'heuristic', refRecover, ii);
		
		disp(['RT FMINCON EXPERIMENT ' num2str(count) ' OF ' num2str(length(expRT))]);
		%experiment(refUsers, jj, 'fmincon', refRecover, ii);
	end	
	
	count=0;
	for jj=expRT
		count = count+1;
		disp(['RT HEURISTIC EXPERIMENT ' num2str(count) ' OF ' num2str(length(expRT))]);
		experiment(refUsers, refRT, 'heuristic', jj, ii);
		
		disp(['RT FMINCON EXPERIMENT ' num2str(count) ' OF ' num2str(length(expRT))]);
		%experiment(refUsers, refRT, 'fmincon', jj, ii);
	end
end

disp('EXPERIMENTS COMPLETED!');