function [avgrates] = avgRates(qn)
% AVGRATES calculate the average rates (including delay nodes) of the
%		queuing network, for each class.
% qn: queuing network
% avgrates: average rates of the queuing network

	persistent envCTMC solCTMC;

	if isa(qn,'CMCQNCSRE')
		
		if ~exist('envCTMC', 'var') || ~isequal(envCTMC, qn.ENV)
			envCTMC = qn.ENV;
			solCTMC = ctmc_solve(qn.ENV);
		end
		
		rates = qn.rates;
		E = qn.E;
		w = solCTMC;
	else
		rates{1} = qn.rates;
		E = 1;
		w = 1;
	end
	
	avgrates = zeros(qn.M, qn.K);
	
	for e=1:E
		avgrates = avgrates + w(e).*rates{e};
	end

end