function [avgRT, cdfRTindex, cdfRTvalue, U, X, R] = evaluateRT(qn)
% EVALUATERT Evaluate response time
% qn: queuing network
% avgRT: average response time
% cdfRTindex: indexes of the response time distribution
% cdfRTvalue: values of the response time distribution

	
	if isa(qn,'CMCQNCSRE')
		[Q, U, R, X, ~, RT_CDF, ~, ~] = CMCQN_CS_RE_analysis_SEFF(qn, [], [], [], ...
			100, 1e-3, 1, (0.001:0.001:0.999)', 1);
	else
		[Q, U, R, X, ~, RT_CDF, ~] = CMCQN_CS_analysis_SEFF(qn, [], [], [], ... 
			100, 1e-3, 1, (0.001:0.001:0.999)', 1);
	end

%  	avgRT = zeros(1,qn.K);
%  	visits = avgVisits(qn);
%  	for ii=1:qn.K
%  		avgRT(ii) = R(:,ii)'*visits(:,ii) - R(qn.refNodes(ii),ii);
% 	end
	

	avgRT = qn.NK'./X;
	for ii=1:qn.K
		if isa(qn,'CMCQNCSRE')
			avgRT(ii) = avgRT(ii) - 1/qn.rates{1}(qn.refNodes(ii),ii);
		else
			avgRT(ii) = avgRT(ii) - 1/qn.rates(qn.refNodes(ii),ii);
		end
	end
	
	cdfRTindex = RT_CDF{1,2}';
	cdfRTvalue = [RT_CDF{:,1}];
	
% 	global failureProbGlobal
% 	
% 	if exist('failureProbGlobal', 'var')
% 		cdfRTindex = cdfRTindex - failureProbGlobal;
% 	else
% 		disp('Warning. failureProbGlobal not defined.');
% 	end
	
end