function [d, cost, avgRT, cdfRTindex, cdfRTvalue, evaluations, time] = ...
	experiment2(users, rt, algorithm, availability, seed)

	global failureProbGlobal
	failureProbGlobal = 1-availability;

	c = Constraints([rt rt rt], 0.8, ...
			[2*rt 2*rt 2*rt]);
					
% load historical data for three eu-west machines
meu1 = Survival('price2/us-east-1a.windows.m3.medium.csv');
meu2 = Survival('price2/us-east-1a.windows.m3.large.csv');
meu3 = Survival('price2/us-east-1a.windows.m3.xlarge.csv');
meu4 = Survival('price2/us-east-1a.windows.m3.2xlarge.csv');

% set the on-demand-price for three eu-west machines
% use the on-demand price
odp = [inf inf inf inf inf inf];
%      0.0649 0.2588 0.5181 0.0672 0.2674 0.5350

recoverTimeHours = 810/3600;
desiredLifeHours = recoverTimeHours*(availability)/(1-availability)

% if strcmp(bidtype, 'ondemand')
	bid1 = meu1.calcMaxBidFromAvgLife(desiredLifeHours);
	bid2 = meu2.calcMaxBidFromAvgLife(desiredLifeHours);
	bid3 = meu3.calcMaxBidFromAvgLife(desiredLifeHours);
	bid4 = meu4.calcMaxBidFromAvgLife(desiredLifeHours);
% elseif strcmp(bidtype, 'ttl')
% 	bid1 = meu1.calcMaxBidFromPercentile(0.90, desiredLife);
% 	bid2 = meu2.calcMaxBidFromPercentile(0.90, desiredLife);
% 	bid3 = meu3.calcMaxBidFromPercentile(0.90, desiredLife);
% 	bid4 = meu4.calcMaxBidFromPercentile(0.90, desiredLife);
% 	bid5 = meu5.calcMaxBidFromPercentile(0.90, desiredLife);
% 	bid6 = meu6.calcMaxBidFromPercentile(0.90, desiredLife);
%else
%	error('bidtype must be ondemand or ttl');
%end

% set the average bidding price and time to leave for three eu-west machines

[~, price1] = meu1.calcAverageLife(bid1);
[~, price2] = meu2.calcAverageLife(bid2);
[~, price3] = meu3.calcAverageLife(bid3);
[~, price4] = meu4.calcAverageLife(bid4);
ttl = [desiredLifeHours desiredLifeHours desiredLifeHours ...
			desiredLifeHours];
bid = [bid1 bid2 bid3 bid4]
price = [price1 price2 price3 price4]

% set rates and cpus
rate =  [3 3.25 3.25 3.25];
%rate = rate*ecuconv;
cpu =   [1 2 4 8];
%cpu = [1 1 1 1 1 1];
%rate = [1 4 8 6.5  13 26]; % ecu

rec = repmat(recoverTimeHours, 1, 6);

% finally create the resources
res = Resources(rate, cpu, price, odp, ttl, rec);

% generate the queuing network of the SAP ERP
qn = QNfactory.newSapErpQN(users);

% reduce the rates of the SAP ERP due to the failure
qn.rates = qn.rates.*availability;
%qn.rates(2:end,:) = qn.rates(2:end,:)*failureProb;

if nargin == 4
	seed = 0;
end

filename = strcat('./results/', num2str(users),'_',num2str(rt),'_', ...
algorithm, '_', num2str(availability),'_', num2str(seed), '.mat');


if strcmp(algorithm, 'heuristic') 
	[ d, cost, avgRT, cdfRTindex, cdfRTvalue, evaluations, time ] = ... 
		findOptimalAllocationFull(qn, c, res, seed);
elseif strcmp(algorithm, 'fmincon')
	[ d, cost, avgRT, cdfRTindex, cdfRTvalue, evaluations, time ] = ... 
		findOptimalAllocationFullFmincon(qn, c, res, seed);
else
	error('algorithm must either be heuristic or fmincon');
end

save(filename, 'd', 'cost', 'avgRT', 'cdfRTindex', 'cdfRTvalue', ...
	'evaluations', 'time');

d
cost
avgRT
RT80=cdfRTvalue(cdfRTindex==0.8)
ecu=sum(sum(d))
evaluations
time
%cdfRTvalue

end % end function



