function [ needed, allocation, cost ] = findOptimalAllocationFmincon(rates, resources)
% *FIXME*
% The allocation matrix should consider only the rented resources and not all of
% them!

%FINDOPTIMUMALLOCATIONFmincon Allocate rates to resources using fmincon
% INPUT
%   rates: rate needed for each station (vector of size M=number of stations)
%   resources: available resources (instance of resources class)
% OUTPUT
%	 needed: vector of size numResources (number of resources to buy, non-negative integer)
%   allocation: matrix M x size(needed) (deployment matrix of stations to
%   actual resources). Each value is a percentage of allocation.
%   cost: total cost for renting the resources

	% Calculate needed resources: needed
	% objective is: minimize the sum needed*resourcecost
	% constraint is: sum of needed*resourcerate > rates
	% needed are non-negative integer value.
	
	[needed, x0, cost] = findOptimalAllocation(rates, resources);
	
	% Decision variable: allocation, percentage of a station rate associated to
	% a given resource (rows: stations, columns: resources)
	
	% Goal
	% maximize the entries in the decision variable that are either equal to 0 or
	% to 1.
	%
	% Constraints
	% sum(allocation(ii,:)) = 1
	% sum(allocation(:,jj)*rates) = needed*resources.rate
	
 	objective = @(x)-sum(sum(x<=eps))-sum(sum(x<=1+eps & x>=1-eps));
	m = length(rates);
	r = resources.size;
	Aeq = zeros(m, m*r);
	A = zeros(r, m*r);
	for ii=1:m
		Aeq(ii,ii:m:end) = 1;
		A(1:r, (1:r) + (ii-1)*r) = A(1:r, (1:r) + (ii-1)*r) + eye(r)*rates(ii);
	end
	Beq = ones(m,1);
	B = (needed.*r)';
	LB = zeros(m,r);
	UB = ones(m,r);
	
	allocation = reshape(fmincon(objective, x0, A, B, Aeq, Beq, LB, UB),m,r);

end
