function [ x, cost, avgRT, cdfRTindex, cdfRTvalue, evaluations, time ] = ...
	findOptimalAllocationFullFmincon(qn, constraints, resources, seed)
% FINDOPTIMALALLOCATIONFULLFMINCON
% Calculate an optimal allocation for the stations of a queuing network on a set
% of resources, subject to some constraints on the response time
% INPUT
% qn: input queuing network
% constraints: response time constraints
% resources: types of available resources
% OUTPUT
% x: allocation matrix
% cost: cost fo allocating the allocation matrix
% avgRT: mean response time
% cdfRTindex: response time percentiles indexes
% cdfRTvalue: response time percentiles values
% evaluations: number of evaluations
% time: time to computer the solution.

	rng(seed);
	time = cputime;

	% initializations
	delayNodes = getDelayNodes(qn);
	bestAvailableRate = max(resources.ecu);
	
	% Calculate feasible rates
	startingRates = findFeasibleRates(qn, constraints);
	for ii=1:numel(startingRates)
		startingRates(ii) = startingRates(ii)*(1+rand());
	end
	rates = findOptimalRates(qn, startingRates, constraints);
	
	
	% Calculate starting allocation
	[ d, ~ ] = findOptimalAllocation(rates(~delayNodes), resources);

	% Calculate the number of resources
	numResources = size(d,2);
	
	rates = rates(~delayNodes).*bestAvailableRate.*0.9./sum(rates(~delayNodes));
	x0 = repmat(rates,1,numResources);
	
	[ x, cost, avgRT, cdfRTindex, cdfRTvalue, evaluations ] = findOptimalAllocationFullNFmincon(qn, constraints, resources, x0);
	%evaluations = evaluations + numResources;
	
	time = cputime - time;
end
