function [ rates, avgRT, cdfRTindex, cdfRTvalue, sumOfRates, evaluations ] = findOptimalRatesFmincon(qn, startingRates, constraints)
%FINDOPTIMALRATESFMINCON Calculate the optimum rates using fmincon
% INPUT:
% qn: queuing network
% constraints: constraints on the response time
% OUTPUT:
% rates: new optimal rates
% avgRT: average respose time
% cdfRTindex: indexes of the response time distribution
% cdfRTvalue: values of the response time distribution
% sumOfRates: sum of the rates for non-delay nodes
% evaluations: number of evaluations of the fluid function

%% number of variables is the number of non delay nodes times the classes
delayNodes = getDelayNodes(qn);

%% initial point
x0 = startingRates; % feasible solution
x0(delayNodes) = [];

%% options
MaxCheckIter=1000;
options = optimset();
options.Display = 'iter';
options.LargeScale = 'off';
options.MaxIter =  100;
options.MaxFunEvals = 1e10;
options.MaxSQPIter = 500;
options.TolCon = 1e-8;
options.Algorithm = 'interior-point';
options.OutputFcn =  @outfun;

XLB = x0*0 + options.TolCon; % lower bounds on x variables
%XUB = ones(n,1) + options.TolCon; % upper bounds on x variables
XUB = x0 + options.TolCon;

% optimization singleton initialization
opt = RatesProblem(qn, constraints);
objfun = @opt.objfun;
nnlcon = @opt.nnlcon;

T0 = tic; % needed for outfun

%% optimization program
[x, sumOfRates]=fmincon(objfun,x0,[],[],[],[],XLB,XUB,nnlcon,options);
rates = ones(qn.M,1);
rates(~delayNodes) = x;
qnRates = avgRates(qn);
qn = setRates(qn, qnRates.*repmat(rates,1,qn.K));
[avgRT, cdfRTindex, cdfRTvalue] = evaluateRT(qn);
evaluations = opt.evaluations + 1;

    function stop = outfun(x, optimValues, state)
        global MAXTIME;
        
        stop = false;
        if strcmpi(state,'iter')
            if mod(optimValues.iteration,MaxCheckIter)==0 && optimValues.iteration>1
                reply = input('Do you want more? Y/N [Y]: ', 's');
                if isempty(reply)
                    reply = 'Y';
                end
                if strcmpi(reply,'N')
                    stop=true;
                end
            end
            if toc(T0)>MAXTIME
                fprintf('Time limit reached. Aborting.\n');
                stop = true;
            end
        end
	 end
 
end

