function [delaynodes] = getDelayNodes(qn)
% GETDELAYNODES get a logic vector that matches delay nodes.
% We assume that a delaynode will remain a delay node through all the stages
% of the queuing network.
%
% qn: queuing network
% delaynodes: logic vector of the delay nodes for the qn


	if isa(qn,'CMCQNCSRE')
		delaynodes = qn.S{1} == -1;
	else
		delaynodes = qn.S == -1;
	end

end