% MYPLOT
function myPlot(parameter, type)

	% varying parameters
	vusers = [500 2000 10000];
	vrt = [70 100 300];
	va = [0.9 0.95 0.999];

	% fixed parameters
	users = 2000;
	rt = 100;
	a = 0.95;
	seed = 1;
	
	if strcmp(parameter,'users')
		users = vusers;
		n = length(users);
		rt = repmat(rt,1,n);
		a = repmat(a,1,n);
		x = users;
		xxlabel = 'Number of users';
	elseif strcmp(parameter,'rt')
		rt = vrt;
		n = length(rt);
		users = repmat(users,1,n);
		a = repmat(a,1,n);
		x = rt;
		xxlabel = 'Maximum average response time';
	elseif strcmp(parameter,'a')
		a = va;
		n = length(va);
		users = repmat(users,1,n);
		rt = repmat(rt,1,n);
		x = a;
		xxlabel = 'Availability';
	else
		error('parameter must be: users or rt or a');
	end

	% load performance
	for ii=1:length(x)

		resH = load(strcat('./results/', num2str(users(ii)),'_',num2str(rt(ii)), ...
			'_heuristic_', num2str(a(ii)), '_', num2str(seed), '.mat'));
		resF = load(strcat('./results/', num2str(users(ii)),'_',num2str(rt(ii)), ...
			'_fmincon_', num2str(a(ii)), '_', num2str(seed), '.mat'));

		costH(ii) = resH.cost;
		ecuH(ii) = sum(sum(resH.d));
		timeH(ii) = resH.time;
		evalH(ii) = resH.evaluations;

		costF(ii) = resF.cost;
		ecuF(ii) = sum(sum(resF.d));
		timeF(ii) = resF.time;
		evalF(ii) = resF.evaluations;
	end
	
	
	
	if strcmp(type,'cost')
		bar([costH; costF]');
		ylabel('Hourly cost (US dollars)');
	elseif strcmp(type,'ecu')
		bar([ecuH; ecuF]');
		ylabel('hourly ECUs');
	elseif strcmp(type,'time')
		bar([timeH; timeF]');
		ylabel('Execution time (seconds)');
	elseif strcmp(type,'evaluations')
		bar([evalH; evalF]');
		ylabel('Queuing network evaluations');
	else
		error('type must be cost or ecu or time or evaluations');
	end
	
	xlabel(xxlabel);
	set(gca, 'xticklabel', num2cell(x));
	legend('Our heuristic', 'Exact approach');
	legend('location', 'northoutside');
	legend('boxoff');
	set(gcf, 'PaperPosition', [0 0 8 6]);
	set(gcf, 'PaperSize', [8 6]);
	set(gca,'FontSize', 24, 'fontweight', 'normal')
	set(findall(gcf,'type','text'),'fontSize',26,'fontWeight','normal')
	name = strcat('plot-',parameter,'-', type);
	saveas(gcf, name, 'pdf');
end




