function [newQN] = setRates(qn, avgrates)
% SETRATES add the given average rates to an existing queuing network.
% qn: queuing network to be modified
% avgRates: new rates to be applied

	newQN = qn;
	persistent envCTMC solCTMC;

	if isa(qn,'CMCQNCSRE')
		
% 		if ~exist('envCTMC', 'var') || ~isequal(envCTMC, qn.ENV)
% 			envCTMC = qn.ENV;
% 			solCTMC = ctmc_solve(qn.ENV);
% 		end
		
		coeff = avgrates./avgRates(qn);
		for e=1:qn.E
			newQN.rates{e} = qn.rates{e}.*coeff;
		end
		
% 		E = qn.E;
% 		w = solCTMC;
		
% 		for e=1:E
% 			newQN.rates{e} = w(e).*avgrates;
% 		end
	else
		newQN.rates = avgrates;
	end

end