% THIS SCRIPT RUNS THE EXPERIMENTS

clear

expset=1:20;

for ii=expset
	disp(['RUNNING EXPERIMENT SET ' num2str(ii) ' OF ' num2str(max(expset))]);

	for jj=1:4
	
		if jj==1
			alg='norefactoring';
		elseif jj==2
			alg='replacement';
		elseif jj==3
			alg='reassignment';
		elseif jj==4
			alg='full';
		end

		% Varying the number of users
		experimentRefactor('2500','ref', 'ref', 'null', 'none', '0.95', alg, num2str(ii));
		experimentRefactor('5000','ref', 'ref', 'null', 'none', '0.95', alg, num2str(ii));
		experimentRefactor('10000','ref', 'ref', 'null', 'none', '0.95', alg, num2str(ii));
		experimentRefactor('20000','ref', 'ref', 'null', 'none', '0.95', alg, num2str(ii));
		experimentRefactor('40000','ref', 'ref', 'null', 'none', '0.95', alg, num2str(ii));
		
		% Trying different replacement sets
		experimentRefactor('10000','ref', 'k1', 'null', 'none', '0.95', alg, num2str(ii));
		experimentRefactor('10000','ref', 'k2', 'null', 'none', '0.95', alg, num2str(ii));
		experimentRefactor('10000','ref', 'k3', 'null', 'none', '0.95', alg, num2str(ii));
		experimentRefactor('10000','ref', 'k4', 'null', 'none', '0.95', alg, num2str(ii));
		experimentRefactor('10000','ref', 'k5', 'null', 'none', '0.95', alg, num2str(ii));
		
		% Adding the merge refactor
% 		experimentRefactor(50000,[100 100 100 100 100], ...
% 			[0.5570*1.2 0.5301*1.2 2.7386*1.2 2.8465*1.2 0.2985*0.8], ...
% 			[0.6795*1.2 0.6979*1.3 2.9153*1.4 3.4760*1.5 0.2118],[0; 10; 10; 10],0.95,alg, ii);
		
		% Changing the performance profile
		experimentRefactor('10000','var1', 'ref', 'null', 'none', '0.95', alg, num2str(ii));
		experimentRefactor('10000','var2', 'ref', 'null', 'none', '0.95', alg, num2str(ii));
		experimentRefactor('10000','var3', 'ref', 'null', 'none', '0.95', alg, num2str(ii));
		experimentRefactor('10000','var4', 'ref', 'null', 'none', '0.95', alg, num2str(ii));
		experimentRefactor('10000','var5', 'ref', 'null', 'none', '0.95', alg, num2str(ii));
		
		% Design constraints
		experimentRefactor('10000','ref', 'ref', 'null', '4', '0.95', alg, num2str(ii));
		experimentRefactor('10000','ref', 'ref', 'null', '34', '0.95', alg, num2str(ii));
		experimentRefactor('10000','ref', 'ref', 'null', '234', '0.95', alg, num2str(ii));

		
		% Different availability
		experimentRefactor('10000','ref', 'ref', 'null', 'none', '0.90', alg, num2str(ii));
		experimentRefactor('10000','ref', 'ref', 'null', 'none', '0.95', alg, num2str(ii));
		experimentRefactor('10000','ref', 'ref', 'null', 'none', '0.99', alg, num2str(ii));
		
	end

		
end


disp('EXPERIMENTS COMPLETED!');