% DRAWPLOT
% This function is used to draw a generic plot
% names: Name for the raw data for the plot
% xspecific: Values for the x-axis for the plot
% xgeneral: Label for the x-axis
% type: Type of the plot ('cost' or 'evaluations')
% plotname: name of the plot pdf
function drawPlot(names, xspecific, xgeneral, type, plotname)

	seeds = 1:20;
	
	for ii=1:numel(names)
		
		for seed=seeds
			res1 = load(strcat('./results/', names{ii}, ...
				'_norefactoring_', num2str(seed), '.mat'));
			res2 = load(strcat('./results/', names{ii}, ...
				'_replacement_', num2str(seed), '.mat'));	
			res3 = load(strcat('./results/', names{ii}, ...
				'_reassignment_', num2str(seed), '.mat'));	
			res4 = load(strcat('./results/', names{ii}, ...
				'_full_', num2str(seed), '.mat'));

			cost1(ii,seed) = res1.cost;
			eval1(ii,seed) = res1.evaluations;
			cost2(ii,seed) = res2.cost;
			eval2(ii,seed) = res2.evaluations;
			cost3(ii,seed) = res3.cost;
			eval3(ii,seed) = res3.evaluations;
			cost4(ii,seed) = res4.cost;
			eval4(ii,seed) = res4.evaluations;
		end
		
	end

	meancost1 = mean(cost1');
	meancost2 = mean(cost2');
	meancost3 = mean(cost3');
	meancost4 = mean(cost4');
	stdcost1 = std(cost1');
	stdcost2 = std(cost2');
	stdcost3 = std(cost3');
	stdcost4 = std(cost4');
	stderrcost1 = 100*std(cost1')./(meancost1.*sqrt(max(seeds)));
	stderrcost2 = 100*std(cost2')./(meancost2.*sqrt(max(seeds)));
	stderrcost3 = 100*std(cost3')./(meancost3.*sqrt(max(seeds)));
	stderrcost4 = 100*std(cost4')./(meancost4.*sqrt(max(seeds)));

	meaneval1 = mean(eval1');
	meaneval2 = mean(eval2');
	meaneval3 = mean(eval3');
	meaneval4 = mean(eval4');
	stdeval1 = std(eval1');
	stdeval2 = std(eval2');
	stdeval3 = std(eval3');
	stdeval4 = std(eval4');
	stderreval1 = 100*std(eval1')./(meaneval1.*sqrt(max(seeds)));
	stderreval2 = 100*std(eval2')./(meaneval2.*sqrt(max(seeds)));
	stderreval3 = 100*std(eval3')./(meaneval3.*sqrt(max(seeds)));
	stderreval4 = 100*std(eval4')./(meaneval4.*sqrt(max(seeds)));
	
	
		
		if strcmp(type,'cost')
			h=barweb([meancost1; meancost2; meancost3; meancost4]', ...
				[stdcost1; stdcost2; stdcost3; stdcost4]');
	
			ylabel('Hourly cost (US dollars)');
		elseif strcmp(type,'evaluations')
			h=barweb([meaneval1; meaneval2; meaneval3; meaneval4]', ...
				[stdeval1; stdeval2; stdeval3; stdeval4]');
			ylabel('Queuing network evaluations');
		else
			error('type must be cost or evaluations');
		end		
	
	xlabel(xgeneral); % varying parameter
	
	set(gca, 'xticklabel', xspecific);
	legend(h.bars,'off');
	legend(h.bars,'No Refactoring', 'Replacement', 'Reassignment', 'Full');
	legend(h.bars,'Orientation','horizontal');
	legend(h.bars,'location', 'eastoutside');
	legend('boxoff');

	set(gcf, 'PaperPosition', [0 0 11 6]);
	set(gcf, 'PaperSize', [11 6]);		
	

	set(gca,'FontSize', 24, 'fontweight', 'normal')
	set(findall(gcf,'type','text'),'fontSize',26,'fontWeight','normal')
	%fileName = strcat('plot-',name, '-', type);
	saveas(gcf, strcat('plots/',plotname), 'pdf');
end




