function [score] = evaluateJobReassignment(qnValue, index)
	% EVALUATEJOBREASSIGNMENT: Calculate the score for reassigning jobs
	% Calculates the score for reassigning jobs in a queuing center.
	%
	% qnValue: evaluated queuing network
	% index: (optional) index of the queueing center to be evaluated
	% score: calculated score as the variance in the non-zero 
	% demands for different classes. 
	% A score of zero means that there is no demand unbalance.
	
	if nargin>1
		indexDemands = qnValue.demands(index,:);
		nonZeroDemands = indexDemands(indexDemands>0);
		score = var(nonZeroDemands);
		
		
		
		return;
	end
	
	qn = qnValue.qn;
	score = zeros(qn.M,1);
	
	for ii=1:qn.M
		if ~strcmp(qn.sched(ii),'inf')
			score(ii) = evaluateJobReassignment(qnValue,ii);
		end
	end
	
	
end