function [speedup] = evaluateSCMerge(qnValue, indexA, indexB, alternatives, constraints)
	% EVALUATESCMERGE: Calculate the score for replacing two software
	% components in the QN with a single component
	%
	% Calculates the score for merging two software component queuing centers
	% into one.
	%
	% qnValue: evaluated queuing network
	% indexA: index of the first software component to be merged
	% indexB: index of the second software component to be merged
	% alternatives: list of alternatives for both components in the form of
	%					 different service rates. Each alternative is a different row
	%					 classes are columns.
	%
	% speedup: calculates the percentage increase in speed for the queuing center
	%			  after the replacement for each alternative. 
	%			  A non-positive score means that the replacement would worsen the 
	%			  performance.
	
	[nAlt, ~] = size(alternatives);
	
		% ALTERNATIVE METHOD (UTILIZATION)
	speedup = zeros(nAlt,1);
	baseU = (sum(qnValue.demands(indexA,:).*qnValue.X)+sum(qnValue.demands(indexA,:).*qnValue.X))/2
	
	for ii=1:nAlt
		%qnAlt = scReplacement(qnValue.qn, index, alternatives(ii,:));
		%qnAltValue = QNValue(qnAlt);
		%qnAltValue = qnAltValue.evaluate();
		%altX = qnAltValue.X
		%altD = qnAltValue.demands(2,:)
		%altU = qnAltValue.U(2)
		newU = (sum(qnValue.visits(indexA,:).*(1./alternatives(ii,:)).*qnValue.X)+sum(qnValue.visits(indexB,:).*(1./alternatives(ii,:)).*qnValue.X))/2
		speedup(ii) = baseU-newU;
	end
	speedup
	% END ALTERNATIVE
	
% 	% ALTERNATIVE METHOD
% 	speedup = zeros(nAlt,1);
% 	baseDistance = max(constraints.distance(qnValue.avgRT, ...
% 		qnValue.cdfRTindex, qnValue.cdfRTvalue));
% 	
% 	for ii=1:nAlt
% 		qnAlt = scMerge(qnValue.qn, indexA, indexB, alternatives(ii,:));
% 		qnAltValue = QNValue(qnAlt);
% 		qnAltValue = qnAltValue.evaluate();
% 		currentDistance = max(constraints.distance(qnAltValue.avgRT, ...
% 			qnAltValue.cdfRTindex, qnAltValue.cdfRTvalue));
% 		speedup(ii) = baseDistance - currentDistance;
% 	end
% 	% END ALTERNATIVE
	
	
% 	qnValue.X./qnValue.qn.NK'
% 	baseDemandA = sum(qnValue.qn.NK'.*qnValue.demands(indexA,:)./constraints.maxAverageRT);
% 	baseDemandB = sum(qnValue.qn.NK'.*qnValue.demands(indexB,:)./constraints.maxAverageRT);
% 	baseDemand = baseDemandA+baseDemandB;
% 	
% 	speedup = zeros(nAlt,1);
% 	
% 	for ii=1:nAlt
% 		visitsA = qnValue.visits(indexA,:);
% 		visitsB = qnValue.visits(indexB,:);
% 		totalVisits = (visitsA+visitsB)/2;
% 		
% 		currentDemand = sum(((qnValue.qn.NK'.*totalVisits./alternatives(ii,:)./constraints.maxAverageRT)));
% 		speedup(ii) = 1+(baseDemand/currentDemand)-1;
% 	end
	
end