function [speedup] = evaluateSCReplacement(qnValue, index, alternatives, constraints)
	% EVALUATESCREPLACEMENT: Calculate the score for replacing a software
	% component in the QN
	%
	% Calculates the score for replacing a software component queuing center.
	% qnValue: evaluated queuing network
	% index: index of the software component to be replaced
	% alternatives: list of alternatives for such component in the form of
	%					 different service rates. Each alternative is a different row
	%					 classes are columns.

	% speedup: calculates the percentage increase in speed for the queuing center
	%			  after the replacement for each alternative. 
	%			  A non-positive score means that the replacement would worsen the 
	%			  performance.
	
	[nAlt, ~] = size(alternatives);

	
	% ALTERNATIVE METHOD (UTILIZATION)
	speedup = zeros(nAlt,1);
	baseU = sum(qnValue.demands(index,:).*qnValue.X);
	X = qnValue.X
	D = qnValue.demands(2,:)
	S = qnValue.qn.rates(2,:)
	V = qnValue.visits(2,:)
	U = qnValue.U(2)
	baseU
	
	for ii=1:nAlt
		%qnAlt = scReplacement(qnValue.qn, index, alternatives(ii,:));
		%qnAltValue = QNValue(qnAlt);
		%qnAltValue = qnAltValue.evaluate();
		%altX = qnAltValue.X
		%altD = qnAltValue.demands(2,:)
		%altU = qnAltValue.U(2)
		newU = sum(qnValue.visits(index,:).*(1./alternatives(ii,:)).*qnValue.X)
		speedup(ii) = baseU-newU;
	end
	speedup
	% END ALTERNATIVE
	
% 	% ALTERNATIVE METHOD (GIULIANO)
% 	speedup = zeros(nAlt,1);
% 	baseDemand = sum(qnValue.demands(index,:).*qnValue.X)/sum(qnValue.X);
% 	X = qnValue.X
% 	D = qnValue.demands(2:end,:)
% 	U = qnValue.U(2:end)
% 	baseDemand
% 	
% 	for ii=1:nAlt
% 		qnAlt = scReplacement(qnValue.qn, index, alternatives(ii,:));
% 		qnAltValue = QNValue(qnAlt);
% 		qnAltValue = qnAltValue.evaluate();
% 		altX = qnAltValue.X
% 		altD = qnAltValue.demands(2:end,:)
% 		altU = qnAltValue.U(2:end)
% 		currentDemand = sum(qnAltValue.demands(index,:).*qnAltValue.X)/sum(qnAltValue.X);
% 		currentDemand
% 		speedup(ii) = (baseDemand/currentDemand) - 1;
% 	end
% 	speedup
% 	% END ALTERNATIVE
	
% 	baseSpeed = sum(qnValue.X./qnValue.qn.NK');
% 	
% 	speedup = zeros(nAlt,1);
% 	
% 	for ii=1:nAlt
% 		diff = alternatives(ii,:)./qnValue.demands(ii,:);
% 		currentSpeed = sum((diff.*qnValue.X./qnValue.qn.NK'));
% 		speedup(ii) = (baseSpeed/currentSpeed)-1;
% 	end
	
end