function [ d, cost, avgRT, cdfRTindex, cdfRTvalue, evaluations, time, nrefactorings ] = ...
	fullRefactor(qn, scAlternatives, mergeAlternatives, maxDuplications, ...
					maxJobReassignments, constraints, resources, seed)
%REFACTOR Apply the software refactoring and the hardware refactoring
%   Detailed explanation goes here
%
% INPUT
% qn: queuing network
% 
% scAlternatives: array of cells in which each cell contains a matrix. Each
% row of the internal matrix contains alternative rates for each class, columns are the classes.
% The indexes of the array are the ones of the replaceable components.
% components.
%
% mergeAlternatives: matrix of cells in which each cell contains a matrix. Each
% row of the internal matrix contains alternative rates for each class, columns are the classes.
%
% The indexes of the matrix are the ones of the mergeable components.
% components.
% maxDuplications: maximum number of additional duplications for the current queuing
% center (vector of qn.M size)
% maxJobReassignments: max number of iterations for reassigning jobs
% constraints: QoS constraints
% resources: available resources
% seed: seed to provide experiment variability

% qnRefactored: new qn after applying refactorings
% nrefactorings: number of refactorings that have been performed
% maxRep: replicability (number of max replica) for the queueing centers of
%			 the resulting queueing network
% 
% OUTPUT
% d: allocation matrix
% cost: cost fo allocating the allocation matrix
% avgRT: mean response time
% cdfRTindex: response time percentiles indexes
% cdfRTvalue: response time percentiles values
% evaluations: number of evaluations
% time: time to compute the solution
% nrefactorings: number of software refactorings.

[qnRefactored, optimalRates, nrefactorings, maxRep] = softwareRefactor(qn, scAlternatives, ...
					mergeAlternatives, maxDuplications, maxJobReassignments);
				
				

				
				
				
				
				
[ d, cost, avgRT, cdfRTindex, cdfRTvalue, evaluations, time ] = ...
				findOptimalAllocationFullLimit(qnRefactored, optimalRates, ...
				constraints, resources, maxRep, seed);
end

