function [ newQN ] = jobReAssignment( qn, index, kbig )

%JOBREASSIGNMET job re-assignment software refactoring
%   It takes a QN with the index of the i-th queueing center where to apply
%   the reassignment of demands by balancing available job classes. 
%   Example: demand-job-class-1= x and demand-job-class-2=y with y>x
%   then the function generates QNcenter-1:(x,x) and QNcenter-2:(0,y-x)
    
	newM = qn.M + 1;

	newS = [qn.S(1:index);qn.S(index:end)];

	newRates = [qn.rates(1:(index),:); qn.rates((index):end,:)];

	newSched = [qn.sched(1:index);qn.sched(index:end)];

	newP = zeros(qn.K*newM, qn.K*newM);

	visits = avgVisits(qn);

	demands = avgDemands(qn,visits);

	%kbig = find(max(demands(index,:)) == demands(index,:));

	for kk=1:qn.K
		 Pk = qn.P(kk:qn.K:end, kk:qn.K:end);
		 newPk = [Pk(1:(index),:); Pk((index):end,:)];
		 newPk = [newPk(:,1:index) newPk(:,index:end)];

		 if kk==kbig
			 newPk(:,index+1) = 0;
			 newPk(index+1, index)=0;
		 else
			  newPk([1:index (index+2):end],index) = 0;
		 end
		 newP(kk:qn.K:end, kk:qn.K:end) = newPk;
	end

	newRefNodes = qn.refNodes;
		newRefNodes(newRefNodes>index) = newRefNodes(newRefNodes>index) + 1;

	newNodeNames = [qn.nodeNames(1:index);qn.nodeNames(index:end)];

	% create new queuing network
		%if isa(qn,'CMCQNCSRE')
			%newQN = CMCQNCSRE(newM, qn.K, qn.E, qn.N, qn.ENV, newS, newRates, newSched, ...
			%	newP, qn.NK, qn.classMatch, newRefNodes, qn.resetRules, ...
			%	newNodeNames, qn.classNames, qn.adhocResetRules);
		%else
			newQN = CMCQNCS(newM, qn.K, qn.N, newS, newRates, newSched, newP, qn.NK, ...
				qn.classMatch, newRefNodes, newNodeNames, qn.classNames);
		%end

	disp(['Reassigning QN' num2str(index) ' class=<' num2str(kbig) '> ' ...
		'olddemands=<' num2str(demands(index,:)) '>']);	
	
end

