function [qnRefactored, nrefactorings] = softwareRefactorSCReplacement(qn, alternatives, constraints, rates)
	% SOFTWAREREFACTORSCREPLACEMENT
	%
	% This function replaces all the software components with substitutes 
	% that increase the score.
	%
	% INPUT
	% qn: queuing network
	% alternatives: array of cells in which each cells contains a matrix. Each
	% row of the matrix contains alternative rates for each class.
	% columns are the classes.
	%
	% OUTPUT
	% qnRefactored: new qn after applying refactorings
	% nrefactorings: number of refactorings that have been performed
	
	nrefactorings = 0;
	qnRefactored = qn;
	myqn = qn;
	
	for ii=1:numel(rates)
 		myqn.rates(ii,:) = myqn.rates(ii,:)*rates(ii);
	end
	
	for ii=1:qn.M
		if strcmp(qn.sched(ii),'inf') || isempty(alternatives{ii})
			continue;
		end
		
		qnv = QNValue(myqn);
		qnv = qnv.evaluate();
		score = evaluateSCReplacement(qnv, ii, alternatives{ii}*rates(ii), constraints);
		maxscore = max(score);
		
		if maxscore>eps
			best = find(score == maxscore);
			best = best(1);
			disp(['Replacing QN' num2str(ii) ': old=<' num2str(qn.rates(ii,:)) ...
				'> new=<' num2str(alternatives{ii}(best,:)) '>']);
			qnRefactored = scReplacement(qnRefactored, ii, alternatives{ii}(best,:));
			myqn = scReplacement(myqn, ii, alternatives{ii}(best,:)*rates(ii));
			nrefactorings = nrefactorings + 1;
		end
	end
	
end