module Circuit where
import Complex
import Gates

type Circuit = ( Int, Int, [Gate] )

-- test circuit
notTestCircuit :: Int -> Int -> Circuit
notTestCircuit (n+1) i = (n+1, i, (sqrtGates [0..n]) ++ (sqrtGates [0..n]) )

flipTestCircuit :: Int -> Int -> Circuit
flipTestCircuit (n+1) i = (n+1, i, (flipGates [0..n]) ++ (flipGates [0..n]) )

-- QFT

qft :: Int -> Int -> [Gate]
qft 0 l = [shorRGate 0]
qft n l = (shorRGate n) : (shorSGates (n-1) (l-1)) ++ qft (n-1) l

qftCircuit :: Int -> Int -> Circuit
qftCircuit (n+1) i = (n+1, i, (qft n (n+1)) )

qftFactor :: Int -> Circuit
qftFactor n = ( d, 0, (qft (n-1) n) ++ swapGates [0..n-1] )
                   where d = n + div (n+1) 2

-- Special

demoCircuit :: Int -> Int -> Circuit
demoCircuit (n+1) i = (n+1, i, (sqrtGates [0..n]) ++ (qft n (n+1)))

