// HaskellEvaluationDialog.cpp : implementation file
//

#include "stdafx.h"
#include "quantum.h"
#include "HaskellEvaluationDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHaskellEvaluationDialog dialog

CString CHaskellEvaluationDialog::m_strDefaultHaskellEval;
CString CHaskellEvaluationDialog::m_strDefaultInputFile;
CString CHaskellEvaluationDialog::m_strDefaultOutputFile;

int CHaskellEvaluationDialog::m_iDefaultBitsFrom = 0;
int CHaskellEvaluationDialog::m_iDefaultBitsTo = 0;
int CHaskellEvaluationDialog::m_iDefaultCircuitInputs = 0;
int CHaskellEvaluationDialog::m_iDefaultCircuitOutputs = 0;
int CHaskellEvaluationDialog::m_iDefaultBitsToOutput = 0;
int CHaskellEvaluationDialog::m_iDefaultOutputFormat = 0;

BOOL CHaskellEvaluationDialog::m_bDefaultOutputToFile = FALSE;


CHaskellEvaluationDialog::CHaskellEvaluationDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CHaskellEvaluationDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHaskellEvaluationDialog)
	m_strHaskellEval    = m_strDefaultHaskellEval;
	m_iBitsFrom         = m_iDefaultBitsFrom;
	m_iBitsTo           = m_iDefaultBitsTo;
	m_strInputFile      = m_strDefaultInputFile;
	m_strOutputFile     = m_strDefaultOutputFile;
	m_bOutputToFile     = m_bDefaultOutputToFile;
	m_iCircuitInputs    = m_iDefaultCircuitInputs;
	m_iCircuitOutputs   = m_iDefaultCircuitOutputs;
	m_iBitsToOutput     = m_iDefaultBitsToOutput;
	m_iOutputFormat     = m_iDefaultOutputFormat;
	//}}AFX_DATA_INIT
}


void CHaskellEvaluationDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHaskellEvaluationDialog)
	DDX_Text(pDX, IDC_CIRCUIT, m_strHaskellEval);
	DDX_Text(pDX, IDC_BITS_FROM, m_iBitsFrom);
	DDV_MinMaxInt(pDX, m_iBitsFrom, 0, 26);
	DDX_Text(pDX, IDC_BITS_TO, m_iBitsTo);
	DDV_MinMaxInt(pDX, m_iBitsTo, 0, 26);
	DDX_Text(pDX, IDC_INPUT_FILE, m_strInputFile);
	DDV_MaxChars(pDX, m_strInputFile, 259);
	DDX_Text(pDX, IDC_OUTPUT_FILE, m_strOutputFile);
	DDV_MaxChars(pDX, m_strOutputFile, 259);
	DDX_Check(pDX, IDC_COPY_TO_FILE, m_bOutputToFile);
	DDX_Radio(pDX, IDC_RADIO_CIRCUIT_INPUTS, m_iCircuitInputs);
	DDX_Radio(pDX, IDC_RADIO_CIRCUIT_OUTPUT, m_iCircuitOutputs);
	DDX_Radio(pDX, IDC_RADIO_OUTPUT_BITS, m_iBitsToOutput);
	DDX_Radio(pDX, IDC_RADIO_OUTPUT_BINARY, m_iOutputFormat);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CHaskellEvaluationDialog, CDialog)
	//{{AFX_MSG_MAP(CHaskellEvaluationDialog)
	ON_BN_CLICKED(IDC_RADIO_INPUT_FROM, OnRadioInputFrom)
	ON_BN_CLICKED(IDC_RADIO_QUANTUM_FACT, OnRadioQuantumFact)
	ON_BN_CLICKED(IDC_RADIO_CIRCUIT_INPUTS, OnRadioCircuitInputs)
	ON_BN_CLICKED(IDC_COPY_TO_FILE, OnOutputToFile)
	ON_BN_CLICKED(IDC_RADIO_SELECT_BITS, OnRadioSelectBits)
	ON_BN_CLICKED(IDC_RADIO_OUTPUT_BITS, OnRadioOutputBits)
	ON_BN_CLICKED(IDC_INPUT_FILE_BROWSE, OnInputFileBrowse)
	ON_BN_CLICKED(IDC_OUTPUT_FILE_BROWSE, OnOutputFileBrowse)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHaskellEvaluationDialog message handlers
void CHaskellEvaluationDialog::OnOK()
{
    CDialog::OnOK();

    m_strDefaultHaskellEval     = m_strHaskellEval;
	m_iDefaultBitsFrom          = m_iBitsFrom;
	m_iDefaultBitsTo            = m_iBitsTo;
	m_strDefaultInputFile       = m_strInputFile;
	m_strDefaultOutputFile      = m_strOutputFile;
	m_bDefaultOutputToFile        = m_bOutputToFile;
	m_iDefaultCircuitInputs     = m_iCircuitInputs;
	m_iDefaultCircuitOutputs    = m_iCircuitOutputs;
	m_iDefaultBitsToOutput      = m_iBitsToOutput;
	m_iDefaultOutputFormat      = m_iOutputFormat;
}

void CHaskellEvaluationDialog::OnRadioInputFrom() 
{
	EnableInputFromBrowse( TRUE );
	
}

void CHaskellEvaluationDialog::OnRadioQuantumFact() 
{
	EnableInputFromBrowse( FALSE );
	
}

void CHaskellEvaluationDialog::OnRadioCircuitInputs() 
{
	EnableInputFromBrowse( FALSE );
	
}

void CHaskellEvaluationDialog::EnableInputFromBrowse( BOOL bEnable )
{
    GetDlgItem( IDC_INPUT_FILE )->EnableWindow( bEnable );
    GetDlgItem( IDC_INPUT_FILE_BROWSE )->EnableWindow( bEnable );
}

BOOL CHaskellEvaluationDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
    EnableInputFromBrowse( m_iCircuitInputs == 1 );
    EnableOutputToFileBrowse( m_bOutputToFile );
    EnableSelectBits( m_iBitsToOutput );
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CHaskellEvaluationDialog::OnOutputToFile() 
{
	BOOL bEnable =  (int) GetDlgItem( IDC_COPY_TO_FILE )->SendMessage(BM_GETCHECK, 0, 0);

    EnableOutputToFileBrowse( bEnable );
}

void CHaskellEvaluationDialog::EnableOutputToFileBrowse( BOOL bEnable )
{
    GetDlgItem( IDC_OUTPUT_FILE )->EnableWindow( bEnable );
    GetDlgItem( IDC_OUTPUT_FILE_BROWSE )->EnableWindow( bEnable );
}

void CHaskellEvaluationDialog::OnRadioSelectBits() 
{
    EnableSelectBits( TRUE );
}

void CHaskellEvaluationDialog::OnRadioOutputBits() 
{
    EnableSelectBits( FALSE );
}

void CHaskellEvaluationDialog::EnableSelectBits( BOOL bEnable )
{
    GetDlgItem( IDC_BITS_FROM )->EnableWindow( bEnable );
    GetDlgItem( IDC_BITS_TO )->EnableWindow( bEnable );
}

void CHaskellEvaluationDialog::OnInputFileBrowse() 
{
    FileBrowse( IDC_INPUT_FILE, TRUE );
}

void CHaskellEvaluationDialog::FileBrowse( UINT nID, BOOL bOpen )
{
    DWORD dwFlags = OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_EXPLORER;
    if( bOpen ) dwFlags |= OFN_FILEMUSTEXIST;

    CString strFile;
    GetDlgItem( nID )->GetWindowText( strFile );

	CFileDialog fdlg( bOpen, NULL, strFile, dwFlags  );

    if( fdlg.DoModal() == IDOK ){
        strFile = fdlg.GetPathName();
        GetDlgItem( nID )->SetWindowText( strFile );
    }
}

void CHaskellEvaluationDialog::OnOutputFileBrowse() 
{
    FileBrowse( IDC_OUTPUT_FILE, FALSE );
}
