// SimProgress.cpp : implementation file
//

#include "stdafx.h"
#include "quantum.h"
#include "SimProgress.h"
#include "matrix.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSimProgress dialog

BOOL CSimProgress::m_bDefaultShowGraph = FALSE;
BOOL CSimProgress::m_bDefaultHistogram = TRUE;


CSimProgress::CSimProgress(CWnd* pParent, CSingleLock &lock)
	: CDialog(CSimProgress::IDD, pParent)
    , m_Lock( lock )
    , m_pcvAmps( NULL )
{
	//{{AFX_DATA_INIT(CSimProgress)
	m_bShowGraph = m_bDefaultShowGraph;
	m_bHistogram = m_bDefaultHistogram;
	//}}AFX_DATA_INIT
}


void CSimProgress::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSimProgress)
	DDX_Control(pDX, IDCANCEL, m_Cancel);
	DDX_Control(pDX, IDC_STATIC_RUNNING, m_StaticRunning);
	DDX_Control(pDX, IDC_PROGRESS_GRAPH, m_ProgressGraph);
	DDX_Control(pDX, IDC_ALGORITHM, m_Algorithm);
	DDX_Control(pDX, IDC_CIRCUIT, m_Circuit);
	DDX_Control(pDX, IDC_TEST_SIZE, m_TestSize);
	DDX_Control(pDX, IDC_TEST, m_Test);
	DDX_Control(pDX, IDC_INFO, m_Info);
	DDX_Control(pDX, IDC_SIM_PROGRESS, m_Progress);
	DDX_Check(pDX, IDC_SHOW_GRAPH, m_bShowGraph);
	DDX_Check(pDX, IDC_HISTOGRAM, m_bHistogram);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSimProgress, CDialog)
	//{{AFX_MSG_MAP(CSimProgress)
	ON_BN_CLICKED(IDC_SHOW_GRAPH, OnShowGraph)
	ON_WM_DRAWITEM()
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_HISTOGRAM, OnHistogram)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSimProgress message handlers

BOOL CSimProgress::OnInitDialog( )
{
    CDialog::OnInitDialog();
    GetDlgItem( IDC_HISTOGRAM )->EnableWindow( m_bShowGraph );

    m_Lock.Unlock();

    return TRUE;

}

void CSimProgress::OnCancel()
{
    m_Lock.Lock();

    m_bDefaultShowGraph = m_bShowGraph;
    m_bDefaultHistogram = m_bHistogram;
    CDialog::OnCancel();
}

void CSimProgress::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	// TODO: Add your message handler code here and/or call default
    if( nIDCtl == IDC_PROGRESS_GRAPH ){
        CDC *pDC = CDC::FromHandle( lpDrawItemStruct->hDC );
        CRect rcItem = lpDrawItemStruct->rcItem;

        CBrush *pOldBrush = (CBrush *) pDC->SelectStockObject( WHITE_BRUSH );
        CPen *pOldPen = (CPen *) pDC->SelectStockObject( BLACK_PEN );
        pDC->Rectangle( rcItem );

        if( m_bShowGraph && m_pcvAmps ){
            CPen MinPen ( PS_SOLID, 1, RGB( 0, 0, 255 ) );
            CPen MeanPen( PS_SOLID, 1, RGB( 0, 255, 0 ) );
            CPen MaxPen ( PS_SOLID, 1, RGB( 255, 0, 0 ) );

            int iXStart = rcItem.left + 1;
            int iXEnd =  rcItem.right - 1;
            int iWidth = rcItem.right - rcItem.left;
            int iUsedData = 0;

            for( int iLog2 = 0; iLog2 < 32 && !(pow2(iLog2) & m_pcvAmps->Length()); iLog2++ );

            ASSERT( iLog2 < 32 );

            int iBucketBits = iLog2 - (iLog2 + 1 ) / 3;
            int iTo = pow2( iBucketBits ) - 1;

            CComplexVector cvProbs;
            CBaseComplexVector *pcv;
            
            if( m_bHistogram ){
                cvProbs.SetLength( pow2( iBucketBits ), TRUE );
                pcv = &cvProbs;
            } else
                pcv = m_pcvAmps;
        
            for( int k = 0; k < m_pcvAmps->Length(); k++ ){
                int iBucket = (k & iTo);

                double d = (*m_pcvAmps)[ k ].MagSquared();
                if( d > 0.000001 ) iUsedData++;

                if( m_bHistogram )
                    cvProbs[ iBucket ] += d;
            }

            double dOverallMax = 0.0;
            for( int j = 0; j < pcv->Length(); j++ ){
                double d;
                if( m_bHistogram )
                    d = (*pcv)[j].Real;
                else
                    d = (*pcv)[j].MagSquared();

                if( d > dOverallMax )
                    dOverallMax = d;
            }

            double dNumbersPerPixel = ((double)pcv->Length()) / iWidth;
            for( int iX = iXStart; iX < iXEnd; iX++ ){
                double dMin  = 1, dMean = 0, dMax  = 0;
                
                int iStartPos = (int) ((iX-iXStart) * dNumbersPerPixel);
                int iEndPos = (int) ((iX+1-iXStart) * dNumbersPerPixel);

                for( int i = iStartPos; i <= iEndPos; i++ ){
                    double dHeight;
                    if( m_bHistogram )
                        dHeight = (*pcv)[i].Real;
                    else
                        dHeight = (*pcv)[i].MagSquared();

                    dMean += dHeight;
                    if( dHeight > dMax ) dMax = dHeight;
                    if( dHeight < dMin ) dMin = dHeight;
                }

                int iBarStart = rcItem.bottom - 14;

                dMean /= (iEndPos +1 - iStartPos);
                pDC->MoveTo( iX, iBarStart);
                pDC->SelectObject( &MinPen );
                pDC->LineTo( iX, iBarStart - (int)((iBarStart - rcItem.top) * dMin / dOverallMax) );
                pDC->SelectObject( &MeanPen );
                pDC->LineTo( iX, iBarStart - (int)((iBarStart - rcItem.top) * dMean / dOverallMax) );
                pDC->SelectObject( &MaxPen );
                pDC->LineTo( iX, iBarStart - (int)((iBarStart - rcItem.top) * dMax / dOverallMax) );

                CRect rcBar = rcItem;
                rcBar.top = rcBar.bottom - 13;
                rcBar.right = rcBar.left + (int)(((double)rcItem.Width()) * iUsedData / m_pcvAmps->Length());
                
                pDC->SelectStockObject( GRAY_BRUSH );
                pDC->SelectStockObject( BLACK_PEN );
                pDC->Rectangle( rcBar );
                pDC->MoveTo( rcBar.left, rcBar.top );
                pDC->LineTo( rcItem.right, rcBar.top );
            }
        }

        pDC->SelectObject( pOldBrush );

    } else
    	CDialog::OnDrawItem(nIDCtl, lpDrawItemStruct);
}

void CSimProgress::SetPos( int iPos, int iRange, CBaseComplexVector *pcvAmps )
{ 
    // We assume that the caller has obtained all the relevant locks,
    // though we make sure that we use PostMessage - to avoid deadlocks
    // in OnCancel
    if( IsWindow( m_Progress.m_hWnd ) )
        ::PostMessage(m_Progress.m_hWnd, PBM_SETRANGE, 0, MAKELPARAM(0, iRange));
    if( IsWindow( m_Progress.m_hWnd ) )
	    ::PostMessage(m_Progress.m_hWnd, PBM_SETPOS, iPos, 0L);

    if( m_bShowGraph && pcvAmps && ::IsWindow( m_ProgressGraph.m_hWnd ) ){
        m_pcvAmps = pcvAmps;
        m_ProgressGraph.Invalidate(FALSE);
    } else
        m_pcvAmps = NULL;
}

void CSimProgress::AlignRightEdge( CWnd *pWnd, int iWindowWidth )
{
    CRect rc;

    pWnd->GetWindowRect( &rc );
    ScreenToClient( &rc );

    rc.right = rc.left + iWindowWidth - 20;
    pWnd->MoveWindow( &rc );
}

void CSimProgress::OnSize(UINT nType, int cx, int cy) 
{
	//CDialog::OnSize(nType, cx, cy);

    if( nType == SIZE_RESTORED && ::IsWindow( m_StaticRunning.m_hWnd ) ){
        CRect rc;
        GetClientRect( &rc );
        int iWidth = rc.Width();

        AlignRightEdge( &m_StaticRunning, iWidth );
        AlignRightEdge( &m_Progress, iWidth );
        AlignRightEdge( &m_ProgressGraph, iWidth );
        AlignRightEdge( &m_Info, iWidth );

        m_Cancel.GetWindowRect( &rc );
        ScreenToClient( &rc );

        int iButtonWidth = rc.right-rc.left;
        rc.left  = (iWidth-20)/2 - iButtonWidth /2;
        rc.right = (iWidth-20)/2 + iButtonWidth /2;
        m_Cancel.MoveWindow( &rc );
    }
	
}

void CSimProgress::OnSizing(UINT nSide, LPRECT lpRect)
{
    lpRect->right = max( lpRect->left + 400, lpRect->right );
    lpRect->bottom = lpRect->top + 475;
}


LRESULT CSimProgress::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	if( message == WM_SIZING ){
        OnSizing( (UINT) wParam, (LPRECT) lParam );
        return 0;
    }
	
	return CDialog::WindowProc(message, wParam, lParam);
}

void CSimProgress::OnHistogram() 
{
	m_bHistogram = (BOOL) GetDlgItem( IDC_HISTOGRAM )->SendMessage(BM_GETCHECK, 0, 0);
}

void CSimProgress::OnShowGraph() 
{
	m_bShowGraph = (BOOL) GetDlgItem( IDC_SHOW_GRAPH )->SendMessage(BM_GETCHECK, 0, 0);
    GetDlgItem( IDC_HISTOGRAM )->EnableWindow( m_bShowGraph );
}

