#include "stdafx.h"
#include "metaverse.h"
#include "qlist.h"
#include "gategroup.h"
#include "SimulateThreaded.h"

// Ooops, can't multithread like this. Don't use this class
CSimulateThreaded::CSimulateThreaded( CMetaverse           *pMetaverse
                                     , CComplexVector       &cvAmps
                                     , CCircuit             *pCircuit
                                     , CQList<CGateGroup>   &listGroups
                                     , int                  iMaxRunningThreads
                                     )
: m_pMetaverse( pMetaverse )
, m_cvAmps( cvAmps )
, m_pCircuit( pCircuit )
, m_listGroups( listGroups )
, m_FreeProcesses( iMaxRunningThreads, iMaxRunningThreads )
, m_FreeGroups( 0, listGroups.Length() )
, m_iWorkDone( 0 )
{
    ASSERT( listGroups.Length() > 0 );
    ASSERT( m_pMetaverse );
    ASSERT( m_pCircuit );

    m_aGroupState = new GroupState[ listGroups.Length() ];

    for( int i = 0; i < listGroups.Length(); i++ ){
        m_aGroupState[i] = Blocked;
    }

    ASSERT( m_aGroupState );
}

CSimulateThreaded::~CSimulateThreaded()
{
    if( m_aGroupState ){
        delete m_aGroupState;
    }
}

void CSimulateThreaded::WaitForTermination( )
{
    CSingleLock l(&m_SimulationFinished, TRUE );
}

void CSimulateThreaded::StartSimulation( int iPriority )
{
    CSingleLock l( &m_ObjectMutex, TRUE );

    m_iThreadsRunning = m_listGroups.Length();

    m_aGroupState[0] = Ready;
    int iOtherReadyGroups = UnblockReadyGroups();

    m_FreeGroups.Unlock( 1 + iOtherReadyGroups );

    for( int i = 0; i < m_iThreadsRunning; i++ ){
        AfxBeginThread( CSimulateThreaded::SimulateGroupsThreadStart, (LPVOID) this, iPriority );
    }
}

int CSimulateThreaded::UnblockReadyGroups( )
{
    int iNewlyUnblocked = 0;

    for( int i = 1; i < m_listGroups.Length(); i++ ){
        if( m_aGroupState[i] == Blocked ){
            BOOL bBlockThis = FALSE;

            for( int j = 0; j < i && !bBlockThis; j++ ){
                if( m_aGroupState[j] != Finished )
                    if( m_listGroups[j] < m_listGroups[i] )
                        bBlockThis = TRUE;
            }
        
            if( !bBlockThis ){
                m_aGroupState[i] = Ready;
                ++iNewlyUnblocked;
            }
        }
    }

    return iNewlyUnblocked;

}

UINT CSimulateThreaded::SimulateGroupsThreadStart( LPVOID lpVoid )
{
    CSimulateThreaded *pThis = (CSimulateThreaded*) lpVoid;
    ASSERT( pThis );

    UINT uReturn = pThis->SimulateGroups();

    {   CSingleLock mutex( &pThis->m_ObjectMutex, TRUE );
        // Will the last one to leave please turn out the lights...
        if( 0 == --pThis->m_iThreadsRunning ){
            mutex.Unlock();
            pThis->m_SimulationFinished.SetEvent();
        }
    }

    return uReturn;
}

UINT CSimulateThreaded::SimulateGroups( )
{
    CSingleLock l1( &m_FreeProcesses, TRUE );
    CSingleLock l2( &m_FreeGroups, TRUE );

    int iReadyGroup = -1;

    {   CSingleLock mutex( &m_ObjectMutex, TRUE );

        for( iReadyGroup = 0; iReadyGroup < m_listGroups.Length(); ++iReadyGroup )
            if( m_aGroupState[iReadyGroup] == Ready )
                break;

        ASSERT( iReadyGroup < m_listGroups.Length() );
        m_aGroupState[iReadyGroup] = Running;
    }


    m_pMetaverse->SimulateGroup( m_cvAmps, m_pCircuit, m_listGroups[iReadyGroup], m_iWorkDone);

    {   CSingleLock mutex( &m_ObjectMutex, TRUE );
    
        m_aGroupState[iReadyGroup] = Finished;

        if( m_iThreadsRunning == 1 ){
            return 0;
        }

        int iNewlyUnblockedGroups = UnblockReadyGroups();

        if( iNewlyUnblockedGroups > 0 )
            m_FreeGroups.Unlock( iNewlyUnblockedGroups );
    }

    return 0;
}
