// Math constants

// Closeness which real numbers have to be to each other to be considered
// equal
#define FLOAT_EQUALITY      0.0001
#define CCOMPLEX_EQUALITY   0.0001

// for pure virtual functions
#define PURE =0

#define FLOAT_EQ( a, b ) (fabs( a - b ) < FLOAT_EQUALITY)

// Funky numbers
#define REC_SQRT2           0.7071067811865      // 1 / sqrt( 2 )


// Power of 2. Table is defined below
#ifdef _DEBUG
#define pow2(a) (( a >= 0 && a < 32) ? g_iPower2[a] : (DebugBreak(), -1))
#else
#define pow2(a) g_iPower2[a]
#endif

// We need to work out the power of two rather quickly, so we
// use a look up table.
static const int g_iPower2[32] = {
    0x00000001, 0x00000002, 0x00000004, 0x00000008,
    0x00000010, 0x00000020, 0x00000040, 0x00000080,
    0x00000100, 0x00000200, 0x00000400, 0x00000800,
    0x00001000, 0x00002000, 0x00004000, 0x00008000,
    0x00010000, 0x00020000, 0x00040000, 0x00080000,
    0x00100000, 0x00200000, 0x00400000, 0x00800000,
    0x01000000, 0x02000000, 0x04000000, 0x08000000,
    0x10000000, 0x20000000, 0x40000000, 0x80000000
};


