// quantumDoc.h : interface of the CQuantumDoc class
//
/////////////////////////////////////////////////////////////////////////////
class CMetaverse;
class CSimProgress;
class CCircuit;

#include "metaverse.h"

// Copy of the ostrstream class. We need to use a slightly different
// constructor for efficiency reasons.
class qostrstream : public ostream {
public:
    qostrstream();

    int	pcount() const { return rdbuf()->out_waiting(); }
    strstreambuf* rdbuf() const { return (strstreambuf*) ios::rdbuf(); }
    char *	str() { return rdbuf()->str(); }
};

class CQuantumDoc : public CDocument
{
protected: // create from serialization only
    CQuantumDoc();
public:
	virtual ~CQuantumDoc();

protected:
    CMetaverse      *m_pMetaverse;          // Metaverse to run the simulation
    CCircuit        *m_pCircuit;            // Circuit to simulate
    CSimProgress    *m_pSimProgress;        // Progress dialog box
    CMutex          m_ProgressMutex;        // Controls access to progress dialog box
    CEvent          m_SimulationFinished;   // Signalled when the simulation finishes
    BOOL            m_bCanRunSimulation;    // True iff we can run a simulation
    BOOL            m_bSimulateSimply;      // True if we are to simulate simply
    int             m_iCalculationPriority; // Thread priority of simulation
    qostrstream      *m_postrstream;         // Output string stream for the simulation
    char            *m_pBuffer;             // buffer for output stream
public:
    BOOL            m_bSparseVectors;       // Type of vectors
    int             m_iMaxThreads;          // max threads in complex sims.


    // Options for the simulation thread
public:
    enum WorkerOptions { RunSingleTest, RunContinuousTests, RunLoadedCircuit };

    // structure which passes details on the simulation to be run to the
    // worker thread. This is kept seperate from the above store to allow
    // for the possible expansion of wanting to run more than one simulation
    // from the same controlling document
protected:
    struct Simdata : public SimParams{
        CQuantumDoc     *m_pDoc;            // Ptr to controlling document
        CSimProgress    *m_pSimProgress;    // Ptr to progress dialog box
        CMutex          *m_pProgressMutex;  // Ptr to progress mutex
        WorkerOptions   m_WorkerOptions;    // Options for the thread
        int             m_iData;            // Numeric data to be passed
	    int             m_iTests;           // Mask for tests to be run
	    int             m_iTestAlgorithms;  // Mask for test algorithms

        CString	        m_strInputFile;     // Input file string
	    CString	        m_strOutputFile;    // output file string
    };

    // Loading 
protected:
	BOOL LoadFrom( CString &strPath, CString &strCircuit, ifstream &ifs );
    BOOL GetHaskellOutput( CString strPath, CString strHaskellEval, ifstream &ifs );
public:
	void LoadTestCircuit( int iCircuit, int iSize );

    // methods for altering options 
public:
    int  GetCalculationPriority( ) { return m_iCalculationPriority; }
    BOOL GetSimpleSimulations( ){ return m_bSimulateSimply; }
    void SetCalculationPriority( int iPriority ){ m_iCalculationPriority = iPriority; }
    void SetSimpleSimulations( BOOL bSimple ){ m_bSimulateSimply = bSimple; }

    // Simulation startup
public:
	void QuantumGo( WorkerOptions workerOptions, int iData, int iTests = 0, int iTestAlgorithms = 0 );

    // Helper methods for running the simulation
protected:
    static UINT SimThreadStart( LPVOID lpVoid );
    static UINT RunSimulation( Simdata *psd );
    static void QuantumSimpleRandomTests( Simdata *psd );

    // Callback by the simulation to inform us of progress
protected:
    static void SimCallback(int iProgress, LPVOID lpVoid, CBaseComplexVector *pcvAmps);

    // Status
public:
    BOOL CanRunSimulation() { return m_bCanRunSimulation; }

    // Output string stuff
public:
    CString GetOutputString();          // Gets the current output text


    // MFC / Visual C++ stuff
	DECLARE_DYNCREATE(CQuantumDoc)

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CQuantumDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	//}}AFX_VIRTUAL

// Implementation
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

// Generated message map functions
protected:
	//{{AFX_MSG(CQuantumDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////
