// quantumView.h : interface of the CQuantumView class
//
/////////////////////////////////////////////////////////////////////////////

class CQuantumView : public CEditView
{
protected: // create from serialization only
	CQuantumView();
	DECLARE_DYNCREATE(CQuantumView)

// Attributes
public:
	CQuantumDoc* GetDocument();

// Operations
public:
    CString m_strLastOutput;
    UINT m_nIDTimer;
    enum { StringTimerID = 1, StringTimerElapse = 1000 };
    void SetText( const CString &cs );

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CQuantumView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CQuantumView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CQuantumView)
	afx_msg void OnQuantumGo();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnRandomTests();
	afx_msg void OnNormalPriority();
	afx_msg void OnBelowNormalPriority();
	afx_msg void OnUpdateBelowNormalPriority(CCmdUI* pCmdUI);
	afx_msg void OnUpdateNormalPriority(CCmdUI* pCmdUI);
	afx_msg void OnUpdateQuantumGo(CCmdUI* pCmdUI);
	afx_msg void OnUpdateRandomTests(CCmdUI* pCmdUI);
	afx_msg void OnSingleTestCircuit();
	afx_msg void OnSimpleSimulation();
	afx_msg void OnEfficientSimulation();
	afx_msg void OnUpdateEfficientSimulation(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSimpleSimulation(CCmdUI* pCmdUI);
	afx_msg void OnQuantumVectorsSparse();
	afx_msg void OnUpdateQuantumVectorsSparse(CCmdUI* pCmdUI);
	afx_msg void OnQuantumVectorsStatic();
	afx_msg void OnUpdateQuantumVectorsStatic(CCmdUI* pCmdUI);
	afx_msg void OnQuantumMaximumThreads(UINT nID);
	afx_msg void OnUpdateQuantumMaximumThreads(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in quantumView.cpp
inline CQuantumDoc* CQuantumView::GetDocument()
   { return (CQuantumDoc*)m_pDocument; }
#endif

//	afx_msg void OnUpdateQuantumMaximumThreads(UINT nID, CCmdUI* pCmdUI);
/////////////////////////////////////////////////////////////////////////////
