// SimProgress.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CSimProgress dialog

class CBaseComplexVector;

class CSimProgress : public CDialog
{
// Construction
    CSingleLock &m_Lock;
    CBaseComplexVector *m_pcvAmps;

    static BOOL m_bDefaultShowGraph;
    static BOOL m_bDefaultHistogram;

public:
	virtual void OnCancel();
	CSimProgress(CWnd* pParent, CSingleLock &lock);   // standard constructor

    void OnSizing(UINT nSide, LPRECT lpRect);
    void AlignRightEdge( CWnd *pWnd, int iWindowWidth );
    void SetPos( int iPos, int iRange, CBaseComplexVector *pcvAmps );
// Dialog Data
	//{{AFX_DATA(CSimProgress)
	enum { IDD = IDD_SIM_PROGRESS };
	CButton	m_Cancel;
	CButton	m_StaticRunning;
	CButton	m_ProgressGraph;
	CStatic	m_Algorithm;
	CStatic	m_Circuit;
	CStatic	m_TestSize;
	CStatic	m_Test;
	CStatic	m_Info;
	CProgressCtrl	m_Progress;
	BOOL	m_bShowGraph;
	BOOL	m_bHistogram;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSimProgress)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CSimProgress)
	afx_msg void OnShowGraph();
	afx_msg void OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnHistogram();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
