#ifndef _PIN_H_
#define _PIN_H_

// pin.h
class CGate;

class CPin {
    CPin *m_pConnectedTo;
    CGate *m_pParentGate;

    int m_iBitNumber;
    enum {OutputPin = 0, InputPin = 1};

public:
    CPin();

    virtual int Direction() = 0;

    CPin * ConnectedTo() const{ return m_pConnectedTo; }

    BOOL IsConnected(){ return ConnectedTo()!=NULL; }

    CGate *SetParent( CGate *pParentGate );
    CGate *ParentGate( ){ return m_pParentGate; }

    int& BitNumber() {return m_iBitNumber;}
    BOOL HasValidBitNumber() {return m_iBitNumber != -1;}

    void ConnectTo( CPin *pOtherPin );
};


class CInputPin : public CPin {
public:
    CInputPin(){ }

    virtual int Direction() { return CPin::InputPin; }

};

class COutputPin : public CPin {
public:
    COutputPin(){ }

    virtual int Direction() { return CPin::OutputPin; }
};

#endif

